/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import java.util.Objects;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    private Context envContext = null;
    private Function<String, String> propertyResolver;

    public ConfigManager() {
        this.propertyResolver = ConfigManager::getHawtioSystemProperty;
    }

    public ConfigManager(Function<String, String> propertyResolver) {
        Objects.requireNonNull(propertyResolver);
        this.propertyResolver = x -> ConfigManager.getProperty(x, ConfigManager::getHawtioSystemProperty, propertyResolver);
    }

    public void init(ServletContext servletContext) {
        if (Boolean.parseBoolean(ConfigManager.getHawtioSystemProperty("forceProperties"))) {
            LOG.info("Forced using system properties");
            return;
        }
        try {
            this.envContext = (Context)new InitialContext().lookup("java:comp/env");
            LOG.info("Configuration will be discovered via JNDI");
        }
        catch (NamingException e) {
            LOG.debug("Failed to look up environment context: ", (Throwable)e);
            LOG.info("Configuration will be discovered via system properties");
        }
    }

    public void destroy() {
        if (this.envContext != null) {
            try {
                this.envContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.envContext = null;
        }
    }

    public String get(String name, String defaultValue) {
        String answer = null;
        if (this.envContext != null) {
            try {
                answer = (String)this.envContext.lookup("hawtio/" + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (answer == null) {
            answer = this.propertyResolver.apply(name);
        }
        if (answer == null) {
            answer = defaultValue;
        }
        LOG.debug("Property {} is set to value {}", (Object)name, (Object)answer);
        return answer;
    }

    private static String getHawtioSystemProperty(String name) {
        return System.getProperty("hawtio." + name);
    }

    @SafeVarargs
    private static String getProperty(String name, Function<String, String> ... propertyResolvers) {
        Function<String, String> resolver;
        String result = null;
        Function<String, String>[] functionArray = propertyResolvers;
        int n = functionArray.length;
        for (int i = 0; i < n && (result = (resolver = functionArray[i]).apply(name)) == null; ++i) {
        }
        return result;
    }
}

