/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(Helpers.class);
    public static final List<String> KNOWN_PRINCIPALS = Arrays.asList("UserPrincipal", "KeycloakPrincipal", "JAASPrincipal", "SimplePrincipal");
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";

    public static void doForbidden(HttpServletResponse response) {
        try {
            response.setStatus(403);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send forbidden response: {}", (Throwable)ioe);
        }
    }

    public static void doAuthPrompt(String realm, HttpServletResponse response) {
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send auth response: {}", (Throwable)ioe);
        }
    }

    public static String getUsernameFromSubject(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        String username = null;
        if (principals != null) {
            for (Principal principal : principals) {
                String principalClass = principal.getClass().getSimpleName();
                if (!KNOWN_PRINCIPALS.contains(principalClass)) continue;
                username = principal.getName();
                LOG.debug("Authorizing user {}", (Object)username);
            }
        }
        return username;
    }

    public static boolean isRunningOnWildFly() {
        return System.getProperty("jboss.server.name") != null;
    }
}

