/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.AuthInfo;
import io.hawt.system.Authenticator;
import io.hawt.system.ConfigManager;
import io.hawt.system.ExtractAuthInfoCallback;
import io.hawt.system.Helpers;
import io.hawt.system.PrivilegedCallback;
import io.hawt.web.AuthenticationConfiguration;
import io.hawt.web.AuthenticationContainerDiscovery;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String HAWTIO_NO_CREDENTIALS_401 = "hawtio.noCredentials401";
    public static final String HAWTIO_AUTHENTICATION_ENABLED = "hawtio.authenticationEnabled";
    public static final String HAWTIO_REALM = "hawtio.realm";
    public static final String HAWTIO_ROLE = "hawtio.role";
    public static final String HAWTIO_ROLES = "hawtio.roles";
    public static final String HAWTIO_ROLE_PRINCIPAL_CLASSES = "hawtio.rolePrincipalClasses";
    public static final String HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES = "hawtio.authenticationContainerDiscoveryClasses";
    public static final String AUTHENTICATION_CONFIGURATION = "authenticationConfig";
    private final AuthenticationConfiguration configuration = new AuthenticationConfiguration();

    public void init(FilterConfig filterConfig) throws ServletException {
        ConfigManager config = (ConfigManager)filterConfig.getServletContext().getAttribute("ConfigManager");
        String defaultRolePrincipalClasses = "";
        if (System.getProperty("karaf.name") != null) {
            defaultRolePrincipalClasses = "org.apache.karaf.jaas.boot.principal.RolePrincipal,org.apache.karaf.jaas.modules.RolePrincipal,org.apache.karaf.jaas.boot.principal.GroupPrincipal";
        }
        String authDiscoveryClasses = "io.hawt.web.tomcat.TomcatAuthenticationContainerDiscovery";
        if (config != null) {
            this.configuration.setRealm(config.get("realm", "karaf"));
            String roles = config.get("role", null);
            if (roles == null) {
                roles = config.get("roles", null);
            }
            if (roles == null) {
                roles = "admin,viewer";
            }
            this.configuration.setRole(roles);
            this.configuration.setRolePrincipalClasses(config.get("rolePrincipalClasses", defaultRolePrincipalClasses));
            this.configuration.setEnabled(Boolean.parseBoolean(config.get("authenticationEnabled", "true")));
            this.configuration.setNoCredentials401(Boolean.parseBoolean(config.get("noCredentials401", "false")));
            authDiscoveryClasses = config.get("authenticationContainerDiscoveryClasses", authDiscoveryClasses);
        }
        if (System.getProperty(HAWTIO_AUTHENTICATION_ENABLED) != null) {
            this.configuration.setEnabled(Boolean.getBoolean(HAWTIO_AUTHENTICATION_ENABLED));
        }
        if (System.getProperty(HAWTIO_NO_CREDENTIALS_401) != null) {
            this.configuration.setNoCredentials401(Boolean.getBoolean(HAWTIO_NO_CREDENTIALS_401));
        }
        if (System.getProperty(HAWTIO_REALM) != null) {
            this.configuration.setRealm(System.getProperty(HAWTIO_REALM));
        }
        if (System.getProperty(HAWTIO_ROLE) != null) {
            this.configuration.setRole(System.getProperty(HAWTIO_ROLE));
        }
        if (System.getProperty(HAWTIO_ROLES) != null) {
            this.configuration.setRole(System.getProperty(HAWTIO_ROLES));
        }
        if (System.getProperty(HAWTIO_ROLE_PRINCIPAL_CLASSES) != null) {
            this.configuration.setRolePrincipalClasses(System.getProperty(HAWTIO_ROLE_PRINCIPAL_CLASSES));
        }
        if (System.getProperty(HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES) != null) {
            authDiscoveryClasses = System.getProperty(HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES);
        }
        if (this.configuration.isEnabled()) {
            List<AuthenticationContainerDiscovery> discoveries = this.getDiscoveries(authDiscoveryClasses);
            for (AuthenticationContainerDiscovery discovery : discoveries) {
                if (!discovery.canAuthenticate(this.configuration)) continue;
                LOG.info("Discovered container {} to use with hawtio authentication filter", (Object)discovery.getContainerName());
                break;
            }
        }
        filterConfig.getServletContext().setAttribute("authenticationEnabled", (Object)this.configuration.isEnabled());
        filterConfig.getServletContext().setAttribute(AUTHENTICATION_CONFIGURATION, (Object)this.configuration);
        if (this.configuration.isEnabled()) {
            LOG.info("Starting hawtio authentication filter, JAAS realm: \"{}\" authorized role(s): \"{}\" role principal classes: \"{}\"", new Object[]{this.configuration.getRealm(), this.configuration.getRole(), this.configuration.getRolePrincipalClasses()});
        } else {
            LOG.info("Starting hawtio authentication filter, JAAS authentication disabled");
        }
    }

    protected List<AuthenticationContainerDiscovery> getDiscoveries(String authDiscoveryClasses) {
        String[] discoveryClasses;
        ArrayList<AuthenticationContainerDiscovery> discoveries = new ArrayList<AuthenticationContainerDiscovery>();
        if (authDiscoveryClasses == null || authDiscoveryClasses.trim().isEmpty()) {
            return discoveries;
        }
        for (String discoveryClass : discoveryClasses = authDiscoveryClasses.split(",")) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(discoveryClass.trim());
                AuthenticationContainerDiscovery discovery = (AuthenticationContainerDiscovery)clazz.newInstance();
                discoveries.add(discovery);
            }
            catch (Exception e) {
                LOG.warn("Couldn't instantiate discovery " + discoveryClass, (Throwable)e);
            }
        }
        return discoveries;
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        Subject subject;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path {}", (Object)path);
        if (this.configuration.getRealm() == null || this.configuration.getRealm().equals("") || !this.configuration.isEnabled()) {
            LOG.debug("No authentication needed for path {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject = (Subject)session.getAttribute("subject")) != null && this.validateSession(httpRequest, session, subject)) {
            AuthenticationFilter.executeAs(request, response, chain, subject);
            return;
        }
        LOG.debug("Doing authentication and authorization for path {}", (Object)path);
        switch (Authenticator.authenticate(this.configuration.getRealm(), this.configuration.getRole(), this.configuration.getRolePrincipalClasses(), this.configuration.getConfiguration(), httpRequest, new PrivilegedCallback(){

            @Override
            public void execute(Subject subject) throws Exception {
                AuthenticationFilter.executeAs(request, response, chain, subject);
            }
        })) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: {
                Helpers.doForbidden((HttpServletResponse)response);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.configuration.isNoCredentials401()) {
                    Helpers.doAuthPrompt(this.configuration.getRealm(), (HttpServletResponse)response);
                    break;
                }
                Helpers.doForbidden((HttpServletResponse)response);
            }
        }
    }

    private boolean validateSession(HttpServletRequest request, HttpSession session, Subject subject) {
        String authHeader = request.getHeader("Authorization");
        final AuthInfo info = new AuthInfo();
        if (authHeader != null && !authHeader.equals("")) {
            Authenticator.extractAuthInfo(authHeader, new ExtractAuthInfoCallback(){

                @Override
                public void getAuthInfo(String userName, String password) {
                    info.username = userName;
                }
            });
        }
        String sessionUser = (String)session.getAttribute("user");
        if (info.username == null || info.username.equals(sessionUser)) {
            LOG.debug("Session subject - {}", (Object)subject);
            return true;
        }
        LOG.debug("User differs, re-authenticating: {} (request) != {} (session)", (Object)info.username, (Object)sessionUser);
        session.invalidate();
        return false;
    }

    private static void executeAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) {
        try {
            if (Helpers.isRunningOnWildFly()) {
                LOG.debug("Running on WildFly / JBoss EAP. Directly invoking filter chain instead of privileged action");
                request.setAttribute("subject", (Object)subject);
                chain.doFilter(request, response);
                return;
            }
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (IOException | PrivilegedActionException | ServletException e) {
            LOG.info("Failed to invoke action " + ((HttpServletRequest)request).getPathInfo() + " due to:", e);
        }
    }

    public void destroy() {
        LOG.info("Destroying hawtio authentication filter");
    }
}

