/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.web.HttpHeaderFilter;
import io.hawt.web.ServletHelpers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSecurityPolicyFilter
extends HttpHeaderFilter {
    private static final transient Logger LOG = LoggerFactory.getLogger(ContentSecurityPolicyFilter.class);
    private static String POLICY = "";
    private static final String POLICY_TEMPLATE = "default-src 'self'; script-src 'self'%s 'unsafe-inline' 'unsafe-eval'; style-src 'self' 'unsafe-inline'; font-src 'self' data:; img-src 'self' data:; connect-src 'self'%s; frame-src 'self'%s";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String keycloakConfigFile = this.getConfigParameter("keycloakClientConfig");
        if (System.getProperty("hawtio.keycloakClientConfig") != null) {
            keycloakConfigFile = System.getProperty("hawtio.keycloakClientConfig");
        }
        boolean addedKeycloakUrl = false;
        if (keycloakConfigFile != null) {
            try (InputStream is = ServletHelpers.loadFile(keycloakConfigFile);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                JSONObject json = ServletHelpers.readObject(reader);
                String url = (String)json.get((Object)"auth-server-url");
                URI uri = URI.create(url);
                LOG.info("Found Keycloak URL: {}", (Object)uri);
                String hostPort = String.format(" %s:%d", uri.getHost(), uri.getPort() > 0 ? uri.getPort() : ("https".equals(uri.getScheme()) ? 443 : 80));
                POLICY = String.format(POLICY_TEMPLATE, hostPort, hostPort, hostPort);
                addedKeycloakUrl = true;
            }
            catch (IOException e) {
                LOG.error("Can't read keycloak configuration file", (Throwable)e);
            }
        }
        if (!addedKeycloakUrl) {
            POLICY = String.format(POLICY_TEMPLATE, "", "", "");
        }
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.addHeader("Content-Security-Policy", POLICY);
    }
}

