/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.git.GitFacade;
import io.hawt.git.GitFileManager;
import io.hawt.git.GitHelper;
import io.hawt.git.WriteCallback;
import io.hawt.git.WriteContext;
import io.hawt.util.Files;
import io.hawt.util.Function;
import io.hawt.util.Strings;
import io.hawt.util.Zips;
import io.hawt.web.GlobalFileUploadFilter;
import io.hawt.web.UploadServlet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitServlet
extends UploadServlet
implements ServiceTrackerCustomizer {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitServlet.class);
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final String GIT_FILE_UPLOAD_PROPNAME = "hawtio.upload.git.filter";
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;
    private GitFileManager gitFacade;
    private List<GlobalFileUploadFilter.MagicNumberFileFilter> gitFileUploadFilters;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.bundleContext = (BundleContext)this.getServletContext().getAttribute("osgi-bundlecontext");
        if (this.bundleContext == null) {
            this.gitFacade = GitFacade.getSingleton();
        } else {
            this.serviceTracker = new ServiceTracker(this.bundleContext, GitFileManager.class.getName(), (ServiceTrackerCustomizer)this);
            this.serviceTracker.open();
        }
    }

    public void destroy() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        if (this.gitFacade == null) {
            throw new ServletException("No GitFacade object available!");
        }
        Params params = this.parsePararams(req, resp);
        if (params == null) {
            return;
        }
        String branch = params.getBranch();
        String path = params.getPath();
        Function<File, Object> callback = new Function<File, Object>(){

            public Object apply(File file) {
                try {
                    String type;
                    String name = file.getName();
                    if (!file.exists() && name.endsWith(".zip")) {
                        String folderName = name.substring(0, name.length() - 4);
                        File dir = new File(file.getParentFile(), folderName);
                        if (dir.exists()) {
                            file = dir;
                        }
                    }
                    if (file.isDirectory() && file.exists()) {
                        file = GitServlet.this.createZip(file);
                    }
                    if ((type = GitServlet.this.getServletContext().getMimeType(file.getAbsolutePath())) == null) {
                        type = "application/octet-stream";
                    }
                    resp.reset();
                    resp.setBufferSize(10240);
                    resp.setContentType(type);
                    if (file.isFile() && file.exists()) {
                        byte[] bytes = Files.readBytes((File)file);
                        int length = bytes.length;
                        LOG.debug("Serving file: " + file.getAbsolutePath() + " of type " + type + " length: " + length);
                        resp.setContentLength(length);
                        resp.getOutputStream().write(bytes);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read file " + file + ". " + e, e);
                }
                return null;
            }
        };
        try {
            this.gitFacade.readFile(branch, path, (Function)callback);
        }
        catch (GitAPIException e) {
            throw new ServletException("Failed to read file: " + path + " on branch " + branch + ". " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected File createZip(File file) throws IOException {
        File answer = File.createTempFile(file.getName(), "zip");
        Zips.createZipFile((Logger)LOG, (File)file, (File)answer);
        return answer;
    }

    @Override
    protected void doPost(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        if (this.gitFacade == null) {
            throw new ServletException("No GitFacade object available!");
        }
        Params params = this.parsePararams(req, resp);
        if (params == null) {
            return;
        }
        String branch = params.getBranch();
        String path = params.getPath();
        WriteCallback<Object> callback = new WriteCallback<Object>(){

            public Object apply(WriteContext context) throws IOException, GitAPIException {
                String lowerFlag;
                File file = context.getFile();
                String unpackZipFlag = req.getParameter("unpackZip");
                boolean unzip = true;
                if (Strings.isNotBlank((String)unpackZipFlag) && ((lowerFlag = unpackZipFlag.toLowerCase()).startsWith("f") || lowerFlag.equals("0"))) {
                    unzip = false;
                }
                List<File> uploadedFiles = null;
                try {
                    if (GitServlet.this.isFileUploadFilterConfigured() && file.length() > GlobalFileUploadFilter.getMaxFileSizeAllowed(GitServlet.this.gitFileUploadFilters)) {
                        throw new FileUploadBase.FileUploadIOException(new FileUploadException("File exceeds its maximum permitted size of bytes."));
                    }
                    uploadedFiles = GitServlet.this.uploadFiles(req, resp, file, GitServlet.this.gitFileUploadFilters);
                }
                catch (ServletException e) {
                    throw new IOException(e);
                }
                GitHelper.doUploadFiles((WriteContext)context, (File)file, (boolean)unzip, uploadedFiles);
                return null;
            }
        };
        try {
            this.gitFacade.writeFile(branch, path, (WriteCallback)callback);
        }
        catch (GitAPIException e) {
            throw new ServletException("Failed to read file: " + path + " on branch " + branch + ". " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected Params parsePararams(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path;
        String requested = req.getPathInfo();
        LOG.debug("Requested file : " + requested);
        if (requested == null) {
            this.notFound(resp);
            return null;
        }
        while (requested.startsWith("/")) {
            requested = requested.substring(1);
        }
        int idx = requested.indexOf(47);
        if (idx < 0) {
            this.notFound(resp);
            return null;
        }
        String branch = requested.substring(0, idx);
        if (branch.length() <= 0) {
            resp.getWriter().println("No branch specified!");
            this.notFound(resp);
        }
        if ((path = requested.substring(idx + 1)) == null || path.length() == 0) {
            path = "/";
        }
        return new Params(branch, path);
    }

    protected void notFound(HttpServletResponse resp) throws IOException {
        resp.sendError(404);
    }

    public Object addingService(ServiceReference serviceReference) {
        LOG.debug("Using new git file manager");
        this.gitFacade = (GitFileManager)this.bundleContext.getService(serviceReference);
        return this.gitFacade;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        LOG.debug("Unsetting git file manager");
        this.gitFacade = null;
        this.bundleContext.ungetService(serviceReference);
    }

    private boolean isFileUploadFilterConfigured() {
        boolean configured = false;
        String config = System.getProperty(GIT_FILE_UPLOAD_PROPNAME);
        try {
            if (config != null) {
                configured = true;
                this.gitFileUploadFilters = GlobalFileUploadFilter.constructFilters(config, new ArrayList<GlobalFileUploadFilter.MagicNumberFileFilter>());
            } else {
                configured = false;
                if (this.gitFileUploadFilters == null || this.gitFileUploadFilters.isEmpty()) {
                    this.gitFileUploadFilters = new ArrayList<GlobalFileUploadFilter.MagicNumberFileFilter>();
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Error configuring filter {}", (Object)config);
        }
        return configured;
    }

    protected static class Params {
        private final String branch;
        private final String path;

        public Params(String branch, String path) {
            this.branch = branch;
            this.path = path;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getPath() {
            return this.path;
        }
    }
}

