/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalFileUploadFilter {
    private static final transient Logger LOG = LoggerFactory.getLogger(GlobalFileUploadFilter.class);
    private static final String FILE_UPLOAD_PROPNAME = "hawtio.upload.filter";
    public static final int ALLOWED_NUMBER_OF_UPLOADS = 10;
    private static final String ZIP_SIGNATURE = "504B0304";
    private List<MagicNumberFileFilter> filters;

    public List<MagicNumberFileFilter> getFilterConfig() {
        return Collections.unmodifiableList(this.getFilters());
    }

    public GlobalFileUploadFilter() {
        String config = System.getProperty(FILE_UPLOAD_PROPNAME);
        if (config != null) {
            LOG.info("Configuring file upload using {} configurations", (Object)config);
            try {
                GlobalFileUploadFilter.constructFilters(config, this.getFilters());
            }
            catch (RuntimeException e) {
                LOG.warn("Error configuring filter {}", (Object)config);
            }
        }
    }

    private static List<String> constructDefaultScriptingContent() {
        String[] scriptContentSearch = new String[]{"#!/usr/bin/python", "#!/usr/local/bin/python", "#!/bin/sh", "#!/usr/bin/env python", "#!/bin/bash", "#!/usr/bin/bash", "#!/usr/local/bash", "#!/usr/local/bin/bash", "#!/usr/bin/env bash", "=<?php", "=<?\\n", "=<?\\r", "#!/usr/local/bin/php", "#!/usr/bin/php", "#!/usr/bin/pdmenu", "eval \"exec perl", "eval \"exec /bin/perl", "eval \"exec /usr/bin/perl", "eval \"exec /usr/local/bin/perl", "eval 'exec perl", "eval 'exec /bin/perl", "eval 'exec /usr/bin/perl", "eval 'exec /usr/local/bin/perl", "eval '(exit $?0)' && eval 'exec", "#!/usr/bin/env perl", "#! /usr/bin/env perl", "#!/bin/node", "#!/usr/bin/node", "#!/bin/nodejs", "#!/usr/bin/nodejs", "#!/usr/bin/env node", "#!/usr/bin/env nodejs", "@", "echo off", "rem", "set", "<html>", "#!/usr/bin/env ruby", "#!/usr/bin/ruby", "#!", "<script>", "goscript", "//usr", "<%", "%>", "..", "/", "\\", "*", "?", "%", ";", "#", "$", "&", "[", "]", "^", "`", "~", ">>", "<<", "...", "#include", "stdio.h", "perl"};
        ArrayList<String> scriptingList = new ArrayList<String>();
        for (int i = 0; i <= scriptContentSearch.length - 1; ++i) {
            scriptingList.add(scriptContentSearch[i]);
        }
        return scriptingList;
    }

    static List<MagicNumberFileFilter> constructFilters(String config, List<MagicNumberFileFilter> filters) {
        String[] var0 = config.split("-");
        for (int i = 0; i <= var0.length - 1; ++i) {
            MagicNumberFileFilter filter = new MagicNumberFileFilter();
            String[] var1 = var0[i].split(",");
            for (int j = 0; j <= var1.length - 1; ++j) {
                String value;
                if (var1[j].toLowerCase().startsWith("signature=") && GlobalFileUploadFilter.validateString(value = var1[j].substring(10))) {
                    filter.setMagicNumbers(GlobalFileUploadFilter.hexStringToByteArray(value));
                }
                if (var1[j].toLowerCase().startsWith("offset=") && GlobalFileUploadFilter.validateString(value = var1[j].toLowerCase().substring(7))) {
                    filter.setByteOffset(Long.parseLong(value));
                }
                if (var1[j].toLowerCase().startsWith("maxsize=") && GlobalFileUploadFilter.validateString(value = var1[j].substring(8))) {
                    filter.setMaxSize(value.trim());
                }
                if (!var1[j].toLowerCase().startsWith("exc=")) continue;
                ArrayList<String> excns = new ArrayList<String>();
                String tmpValue = var1[j].substring(5);
                if (GlobalFileUploadFilter.validateString(tmpValue) && tmpValue.charAt(tmpValue.length() - 1) == ']') {
                    tmpValue = tmpValue.substring(0, tmpValue.length() - 1);
                }
                String[] vars = tmpValue.split("\\s+");
                for (int k = 0; k < vars.length; ++k) {
                    excns.add(vars[k]);
                }
                filter.setExceptions((List<String>)(!excns.isEmpty() ? excns : new ArrayList<String>()));
            }
            filters.add(filter);
        }
        return filters;
    }

    private static boolean validateString(String tmpValue) {
        return tmpValue != null && tmpValue.length() > 0;
    }

    protected static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static long translateFileSize(String size) {
        if (size.toLowerCase().trim().contains("bytes")) {
            String normalized = size.toLowerCase().replace("bytes", "").trim();
            return Long.parseLong(!normalized.equals("") ? normalized : "0");
        }
        if (size.toLowerCase().trim().contains("kb")) {
            String normalized = size.toLowerCase().replace("kb", "").trim();
            return 1024L * Long.parseLong(!normalized.equals("") ? normalized : "0");
        }
        if (size.toLowerCase().trim().contains("mb")) {
            String normalized = size.toLowerCase().replace("mb", "").trim();
            return 0x100000L * Long.parseLong(!normalized.equals("") ? normalized : "0");
        }
        if (size.toLowerCase().trim().contains("gb")) {
            String normalized = size.toLowerCase().replace("gb", "").trim();
            return 0x40000000L * Long.parseLong(!normalized.equals("") ? normalized : "0");
        }
        return 0L;
    }

    public static synchronized boolean accept(byte[] fileContent, List<MagicNumberFileFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        boolean fileAccepted = false;
        for (MagicNumberFileFilter magicNumberFileFilter : filters) {
            if (magicNumberFileFilter.getMagicNumbers().length > 0 && (long)fileContent.length >= magicNumberFileFilter.getByteOffset() + (long)magicNumberFileFilter.getMagicNumbers().length) {
                byte[] fileMagicBytes = Arrays.copyOfRange(fileContent, Math.toIntExact(magicNumberFileFilter.getByteOffset()), Math.toIntExact(magicNumberFileFilter.getByteOffset()) + magicNumberFileFilter.getMagicNumbers().length);
                boolean matched = Arrays.equals(magicNumberFileFilter.getMagicNumbers(), fileMagicBytes);
                if (!matched) continue;
                fileAccepted = true;
                if (magicNumberFileFilter.getMaxSize() != null) {
                    String fileSize = FileUtils.byteCountToDisplaySize((long)fileContent.length);
                    fileAccepted = GlobalFileUploadFilter.translateFileSize(fileSize) <= GlobalFileUploadFilter.translateFileSize(magicNumberFileFilter.getMaxSize());
                }
                if (!Arrays.equals(magicNumberFileFilter.getMagicNumbers(), GlobalFileUploadFilter.hexStringToByteArray(ZIP_SIGNATURE)) || !fileAccepted) continue;
                try {
                    fileAccepted = GlobalFileUploadFilter.unzip(fileContent, filters);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (magicNumberFileFilter.getExceptions() == null) continue;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(fileContent.length);
            outputStream.write(fileContent, 0, fileContent.length);
            HashSet<String> excList = new HashSet<String>();
            for (String s : GlobalFileUploadFilter.constructDefaultScriptingContent()) {
                if (magicNumberFileFilter.getExceptions() == null || magicNumberFileFilter.getExceptions().contains(s)) continue;
                excList.add(s);
            }
            if (GlobalFileUploadFilter.isAsciiContentDangerous(outputStream, excList)) continue;
            fileAccepted = true;
        }
        return fileAccepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzip(byte[] fileContent, List<MagicNumberFileFilter> fileFilter) throws IOException {
        long maxSize = 0x500000L;
        int tooMany = 100;
        int buffer = 512;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(fileContent));
        boolean safe = true;
        int entries = 0;
        long total = 0L;
        try {
            while (zipInputStream.getNextEntry() != null) {
                int count;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] data = new byte[buffer];
                boolean isAscii = true;
                while (total + (long)buffer <= maxSize && (count = zipInputStream.read(data, 0, buffer)) != -1) {
                    if (isAscii) {
                        isAscii = GlobalFileUploadFilter.isAsciiFile(data, count);
                    }
                    outputStream.write(data, 0, count);
                    total += (long)count;
                }
                if (outputStream.toByteArray().length > 0) {
                    byte[] entryContent = outputStream.toByteArray();
                    boolean configured = GlobalFileUploadFilter.accept(entryContent, fileFilter);
                    if (configured) continue;
                    if (isAscii) {
                        if (!configured && GlobalFileUploadFilter.isExceptionConfigured(fileFilter)) {
                            Set<String> finalProhibitedList = GlobalFileUploadFilter.getFinalProhibitedList(fileFilter);
                            safe = !GlobalFileUploadFilter.isAsciiContentDangerous(outputStream, finalProhibitedList);
                        }
                        if (!configured && !GlobalFileUploadFilter.isExceptionConfigured(fileFilter)) {
                            safe = !GlobalFileUploadFilter.isAsciiContentDangerous(outputStream, new HashSet<String>(GlobalFileUploadFilter.constructDefaultScriptingContent()));
                        }
                    } else {
                        safe = false;
                    }
                }
                if (!safe) {
                    boolean bl = safe;
                    return bl;
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            zipInputStream.closeEntry();
            if (++entries > tooMany) {
                throw new IllegalStateException("Too many files to unzip");
            }
            if (total > maxSize) {
                throw new IllegalStateException("File being unzipped is too big");
            }
        }
        finally {
            zipInputStream.close();
        }
        return safe;
    }

    static boolean isAsciiFile(byte[] content, int len) {
        for (int i = 0; i < len; ++i) {
            if ((0x80 & content[i]) == 0) continue;
            return false;
        }
        return true;
    }

    static Set<String> getFinalProhibitedList(List<MagicNumberFileFilter> fileFilter) {
        HashSet<String> finalProhibitedList = new HashSet<String>();
        for (String s : GlobalFileUploadFilter.constructDefaultScriptingContent()) {
            for (MagicNumberFileFilter m : fileFilter) {
                if (m.getExceptions() == null || m.getExceptions().contains(s)) continue;
                finalProhibitedList.add(s);
            }
        }
        return finalProhibitedList;
    }

    private static boolean isExceptionConfigured(List<MagicNumberFileFilter> fileFilter) {
        boolean configured = true;
        for (MagicNumberFileFilter filter : fileFilter) {
            if (filter.getExceptions() == null) {
                configured = false;
                continue;
            }
            configured = true;
        }
        return configured;
    }

    static boolean isAsciiContentDangerous(ByteArrayOutputStream outputStream, Set<String> finalProhibitedList) {
        boolean dangerousContentDetected = false;
        StringBuilder builder = new StringBuilder();
        for (byte b : outputStream.toByteArray()) {
            builder.append((char)b);
        }
        Object object = finalProhibitedList.iterator();
        while (object.hasNext()) {
            String s = (String)object.next();
            if (!builder.toString().startsWith(s) && !builder.toString().contains(s)) continue;
            dangerousContentDetected = true;
        }
        return dangerousContentDetected;
    }

    public static long getMaxFileSizeAllowed(List<MagicNumberFileFilter> filters) {
        if (filters.size() == 0) {
            return -1L;
        }
        long maxSize = -1L;
        try {
            long[] fileSizes = new long[filters.size()];
            for (int i = 0; i <= filters.size() - 1; ++i) {
                fileSizes[i] = GlobalFileUploadFilter.translateFileSize(filters.get(i).getMaxSize());
            }
            maxSize = fileSizes[0];
            for (int j = 0; j <= fileSizes.length - 1; ++j) {
                if (maxSize == fileSizes[j] || fileSizes[j] <= maxSize) continue;
                maxSize = fileSizes[j];
            }
        }
        catch (RuntimeException e) {
            LOG.error("Error calculating max file size");
        }
        return maxSize;
    }

    public static GlobalFileUploadFilter newFileUploadFilter() {
        return new GlobalFileUploadFilter();
    }

    private List<MagicNumberFileFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<MagicNumberFileFilter>();
        }
        return this.filters;
    }

    public static final class MagicNumberFileFilter {
        private byte[] magicNumbers = new byte[0];
        private long byteOffset;
        private String maxSize = "200bytes";
        private List<String> exceptions;

        public byte[] getMagicNumbers() {
            return this.magicNumbers;
        }

        public void setMagicNumbers(byte[] magicNumbers) {
            if (magicNumbers.length == 0) {
                throw new IllegalArgumentException("The magic number must contain at least one byte");
            }
            this.magicNumbers = magicNumbers;
        }

        public long getByteOffset() {
            return this.byteOffset;
        }

        public void setByteOffset(long byteOffset) {
            if (byteOffset < 0L) {
                throw new IllegalArgumentException("The offset cannot be negative");
            }
            this.byteOffset = byteOffset;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(String maxSize) {
            if (maxSize != null) {
                this.maxSize = maxSize;
            }
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(List<String> exceptions) {
            this.exceptions = exceptions;
        }
    }
}

