/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JavaDocServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private String[] argumentTypes = new String[]{"java.lang.String", "java.lang.String"};

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (this.mbeanServer == null) {
                this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.objectName == null) {
                this.objectName = new ObjectName("hawtio:type=LogQuery");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException("Failed to initialise LogQuery MBean: " + e, (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (this.mbeanServer != null && this.objectName != null) {
            while (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            int idx = pathInfo.indexOf(47);
            if (idx > 0) {
                String mavenCoords = pathInfo.substring(0, idx);
                String path = pathInfo.substring(idx + 1);
                if (path == null || path.trim().length() == 0) {
                    path = "index.html";
                }
                Object[] arguments = new Object[]{mavenCoords, path};
                try {
                    Object answer = this.mbeanServer.invoke(this.objectName, "getJavaDoc", arguments, this.argumentTypes);
                    if (answer instanceof String) {
                        if (!pathInfo.endsWith(".css")) {
                            resp.setContentType("text/html;charset=utf-8");
                        }
                        resp.getWriter().println(answer);
                    }
                }
                catch (Exception e) {
                    throw new ServletException("Failed to find javadoc from maven coordinates " + mavenCoords + " path " + path + ". Reason " + e, (Throwable)e);
                }
            }
        }
    }
}

