/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.Strings;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDetails {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProxyDetails.class);
    private boolean invalid;
    private String scheme = "http";
    private String path = "";
    private String userName;
    private String password;
    private String host;
    private String queryString = null;
    private int port = 80;
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_SCHEME = "http";
    private static final int HTTPS_PORT = 443;
    private static final String HTTPS_SCHEME = "https";
    private static final Pattern pathInfoPattern = Pattern.compile("^(?:\\/*(?:(?<scheme>[^:]+):\\/\\/?)?(?:(?<username>[^:]+):(?<password>.*)@)?)?(?<host>[^\\/]+)(?:[\\/:](?<port>\\d+)?)(?<path>[^\\?]+).*$");
    private static final Pattern removeIgnoredHeaderNamesPattern = Pattern.compile("(^|(?<=[?&;]))(?:_user|_pwd|_url|url)=.*?($|[&;])");

    public ProxyDetails(HttpServletRequest httpServletRequest) {
        this.parsePathInfo(httpServletRequest.getPathInfo());
        String reqQueryString = httpServletRequest.getQueryString();
        if (reqQueryString != null) {
            this.queryString = removeIgnoredHeaderNamesPattern.matcher(reqQueryString).replaceAll("");
        }
    }

    public ProxyDetails(String scheme, String path, String userName, String password, String host, String queryString, int port) {
        this.scheme = scheme;
        this.path = path;
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.queryString = queryString;
        this.port = port;
    }

    private void parsePathInfo(String pathInfo) {
        if (Strings.isBlank((String)pathInfo)) {
            this.invalid = true;
            return;
        }
        Matcher matcher = pathInfoPattern.matcher(pathInfo);
        if (matcher.matches()) {
            this.userName = matcher.group("username");
            this.password = matcher.group("password");
            this.scheme = matcher.group("scheme");
            if (this.scheme == null) {
                this.scheme = DEFAULT_SCHEME;
            }
            this.host = matcher.group("host");
            this.port = matcher.group("port") != null ? Integer.parseInt(matcher.group("port")) : (this.scheme.equalsIgnoreCase(DEFAULT_SCHEME) ? 80 : 443);
            this.path = matcher.group("path");
            if (!this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
            if (this.path.contains("\"")) {
                this.path = this.path.replaceAll("\\\"", "%22");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxying to " + this.getFullProxyUrl() + " as user: " + this.userName);
            }
        } else {
            this.invalid = true;
        }
    }

    public boolean isAllowed(Set<String> whitelist) {
        if (whitelist.contains("*")) {
            return true;
        }
        return whitelist.contains(this.host.split(":")[0]);
    }

    public boolean isAllowed(List<Pattern> regexWhitelist) {
        String hostWithoutPort = this.host.split(":")[0];
        for (Pattern pattern : regexWhitelist) {
            if (!pattern.matcher(hostWithoutPort).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ProxyDetails{" + this.userName + "@" + this.getFullProxyUrl() + "}";
    }

    public String getFullProxyUrl() {
        if (this.invalid) {
            return null;
        }
        return this.scheme + "://" + this.getHostAndPort() + this.path + (Strings.isBlank((String)this.queryString) ? "" : "?" + this.queryString);
    }

    public String getProxyPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostAndPort() {
        if (this.scheme.equalsIgnoreCase(DEFAULT_SCHEME) && this.port == 80) {
            return this.host;
        }
        if (this.scheme.equalsIgnoreCase(HTTPS_SCHEME) && this.port == 443) {
            return this.host;
        }
        return this.host + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.host != null;
    }
}

