/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.web.RBACMBeanInvoker;
import java.io.IOException;
import javax.management.ObjectName;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.NetworkUtil;
import org.jolokia.util.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACRestrictor
implements Restrictor {
    private static final transient Logger LOG = LoggerFactory.getLogger(RBACRestrictor.class);
    protected Restrictor delegate;
    protected RBACMBeanInvoker mBeanInvoker;

    public RBACRestrictor(Configuration config) {
        this.initDelegate(config);
        this.mBeanInvoker = new RBACMBeanInvoker();
    }

    protected void initDelegate(Configuration config) {
        String location = NetworkUtil.replaceExpression((String)config.get(ConfigKey.POLICY_LOCATION));
        try {
            this.delegate = RestrictorFactory.lookupPolicyRestrictor((String)location);
            if (this.delegate != null) {
                LOG.debug("Delegate - Using policy access restrictor {}", (Object)location);
            } else {
                LOG.debug("Delegate - No policy access restrictor found, access to any MBean is allowed");
                this.delegate = new AllowAllRestrictor();
            }
        }
        catch (IOException e) {
            LOG.error("Delegate - Error while accessing access policy restrictor at " + location + ". Denying all access to MBeans for security reasons. Exception: " + e, (Throwable)e);
            this.delegate = new DenyAllRestrictor();
        }
    }

    public boolean isOperationAllowed(ObjectName objectName, String operation) {
        boolean allowed = this.delegate.isOperationAllowed(objectName, operation);
        if (allowed) {
            allowed = this.mBeanInvoker.canInvoke(objectName, operation);
        }
        LOG.debug("isOperationAllowed(objectName = {}, operation = {}) = {}", new Object[]{objectName, operation, allowed});
        return allowed;
    }

    public boolean isAttributeReadAllowed(ObjectName objectName, String attribute) {
        boolean allowed = this.delegate.isAttributeReadAllowed(objectName, attribute);
        if (allowed) {
            allowed = this.mBeanInvoker.isReadAllowed(objectName, attribute);
        }
        LOG.debug("isAttributeReadAllowed(objectName = {}, attribute = {}) = {}", new Object[]{objectName, attribute, allowed});
        return allowed;
    }

    public boolean isAttributeWriteAllowed(ObjectName objectName, String attribute) {
        boolean allowed = this.delegate.isAttributeWriteAllowed(objectName, attribute);
        if (allowed) {
            allowed = this.mBeanInvoker.isWriteAllowed(objectName, attribute);
        }
        LOG.debug("isAttributeWriteAllowed(objectName = {}, attribute = {}) = {}", new Object[]{objectName, attribute, allowed});
        return allowed;
    }

    public boolean isHttpMethodAllowed(HttpMethod method) {
        boolean allowed = this.delegate.isHttpMethodAllowed(method);
        LOG.trace("isHttpMethodAllowed(method = {}) = {}", (Object)method, (Object)allowed);
        return allowed;
    }

    public boolean isTypeAllowed(RequestType type) {
        boolean allowed = this.delegate.isTypeAllowed(type);
        LOG.trace("isTypeAllowed(type = {}) = {}", (Object)type, (Object)allowed);
        return allowed;
    }

    public boolean isRemoteAccessAllowed(String ... hostOrAddress) {
        boolean allowed = this.delegate.isRemoteAccessAllowed(hostOrAddress);
        LOG.trace("isRemoteAccessAllowed(hostOrAddress = {}) = {}", (Object)hostOrAddress, (Object)allowed);
        return allowed;
    }

    public boolean isOriginAllowed(String origin, boolean strictCheck) {
        boolean allowed = this.delegate.isOriginAllowed(origin, strictCheck);
        LOG.trace("isOriginAllowed(origin = {}, strictCheck = {}) = {}", new Object[]{origin, strictCheck, allowed});
        return allowed;
    }
}

