/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.Strings;
import io.hawt.web.RelativeRequestUri;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectFilter
implements Filter {
    public static final String ALLOWED_CONTEXTS = "allowedContexts";
    private static final Logger LOG = LoggerFactory.getLogger(RedirectFilter.class);
    private static final String[] KNOWN_SERVLETS = new String[]{"jolokia", "auth", "upload", "javadoc", "proxy", "springBatch", "user", "plugin", "exportContext", "contextFormatter", "refresh", "keycloak"};
    private final Set<String> knownServlets = new HashSet<String>(Arrays.asList(KNOWN_SERVLETS));
    private int pathIndex;

    public void init(FilterConfig cfg) throws ServletException {
        String servletPath = (String)cfg.getServletContext().getAttribute("hawtioServletPath");
        this.pathIndex = servletPath == null ? 0 : Strings.webContextPath((String)servletPath, (String[])new String[0]).replaceAll("[^/]+", "").length();
        String allowedContexts = cfg.getInitParameter(ALLOWED_CONTEXTS);
        if (allowedContexts != null) {
            for (String s : allowedContexts.split(",")) {
                this.knownServlets.add(Strings.webContextPath((String)s.trim(), (String[])new String[0]).replaceAll("^/+|/+$", ""));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Known servlets are: {}", new TreeSet<String>(this.knownServlets));
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            this.process((HttpServletRequest)req, (HttpServletResponse)res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    private void process(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        RelativeRequestUri uri = new RelativeRequestUri(req, this.pathIndex);
        LOG.debug("Accessing [{}], hawtio path is [{}]", (Object)req.getRequestURI(), (Object)uri.getUri());
        if (this.isValid(uri)) {
            LOG.debug("[{}] is a valid hawtio path, allowing", (Object)uri.getUri());
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            String newUri = this.buildRedirectUri(uri);
            LOG.debug("[{}] is an invalid hawtio path, redirecting to: {}", (Object)uri.getUri(), (Object)newUri);
            res.sendRedirect(newUri);
        }
    }

    protected boolean isValid(RelativeRequestUri uri) {
        if (uri.getComponents().length == 0) {
            return true;
        }
        if (uri.getLastComponent().contains(".") && !uri.getLastComponent().endsWith(".profile")) {
            return true;
        }
        return this.knownServlets.contains(uri.getComponents()[0]);
    }

    protected String buildRedirectUri(RelativeRequestUri uri) {
        StringBuilder b = new StringBuilder();
        if (!uri.getPrefix().startsWith("/")) {
            b.append('/');
        }
        b.append(uri.getPrefix());
        if (b.charAt(b.length() - 1) != '/') {
            b.append('/');
        }
        b.append('#');
        for (String p : uri.getComponents()) {
            b.append('/').append(p);
        }
        if (uri.getRequest().getQueryString() != null && !"".equals(uri.getRequest().getQueryString())) {
            b.append("?").append(uri.getRequest().getQueryString());
        }
        return b.toString();
    }

    public void destroy() {
    }
}

