/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.Strings;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class RelativeRequestUri {
    private static final Pattern PATH_SPLITTER = Pattern.compile("/");
    private final HttpServletRequest request;
    private final String uriPrefix;
    private final String uri;
    private final String[] uriComponents;

    public RelativeRequestUri(HttpServletRequest request, int pathIndex) {
        if (pathIndex < 0) {
            throw new IllegalArgumentException("pathIndex is negative");
        }
        String requestUri = Strings.webContextPath((String)request.getRequestURI(), (String[])new String[0]);
        int start = request.getContextPath().length();
        if (start < requestUri.length() && requestUri.charAt(start) == '/') {
            ++start;
        }
        if (pathIndex != 0) {
            int c = 0;
            do {
                int i;
                if ((start = (i = requestUri.indexOf(47, start)) + 1) != 0) continue;
                start = requestUri.length();
                break;
            } while (++c < pathIndex);
        }
        if (start < requestUri.length()) {
            this.uriPrefix = requestUri.substring(0, start);
            this.uri = requestUri.substring(start);
        } else {
            this.uriPrefix = requestUri;
            this.uri = "";
        }
        this.uriComponents = this.uri.isEmpty() ? new String[]{} : PATH_SPLITTER.split(this.uri);
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getPrefix() {
        return this.uriPrefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String[] getComponents() {
        return this.uriComponents;
    }

    public String getLastComponent() {
        return this.uriComponents.length == 0 ? null : this.uriComponents[this.uriComponents.length - 1];
    }

    public String toString() {
        return this.getUri();
    }
}

