/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.IOHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHelpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(ServletHelpers.class);

    public static JSONObject readObject(BufferedReader reader) throws IOException {
        String data = IOHelper.readFully((BufferedReader)reader);
        JSONParser parser = new JSONParser();
        try {
            return (JSONObject)parser.parse(data);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    static void writeEmpty(PrintWriter out) {
        out.write("{}");
        out.flush();
        out.close();
    }

    static void writeObject(Converters converters, JsonConvertOptions options, PrintWriter out, Object answer) {
        Object result = null;
        try {
            result = converters.getToJsonConverter().convertToJson(answer, null, options);
        }
        catch (AttributeNotFoundException e) {
            LOG.warn("Failed to convert object to json", (Throwable)e);
        }
        if (result != null) {
            out.write(result.toString());
            out.flush();
            out.close();
        } else {
            ServletHelpers.writeEmpty(out);
        }
    }

    public static Map populateTableMapForXl(List listEntry) {
        listEntry = ServletHelpers.flatten(listEntry);
        HashMap xlData = new HashMap();
        Set columns = ServletHelpers.getColumns(listEntry);
        List rowsData = ServletHelpers.getRowsData(listEntry, columns);
        xlData.put("columns", columns);
        xlData.put("rows", rowsData);
        return xlData;
    }

    public static Map populateErrorTableMapForXl(List listEntry) {
        listEntry = ServletHelpers.flatten(listEntry);
        HashMap<String, AbstractCollection> xlData = new HashMap<String, AbstractCollection>();
        HashSet<String> columns = new HashSet<String>();
        columns.add("Error Message");
        ArrayList rowsData = new ArrayList();
        for (Object o : listEntry) {
            HashMap<String, String> keyValuePairs = new HashMap<String, String>();
            keyValuePairs.put(columns.toArray()[0].toString(), ServletHelpers.removeNoisyString(o.toString()));
            rowsData.add(keyValuePairs);
        }
        xlData.put("columns", columns);
        xlData.put("rows", rowsData);
        return xlData;
    }

    private static Set getColumns(List listEntry) {
        HashSet set = new HashSet();
        for (Object o : listEntry) {
            if (!(o instanceof JSONObject)) continue;
            set.addAll(((JSONObject)o).keySet());
        }
        return set;
    }

    private static List getRowsData(List listEntry, Set columns) {
        ArrayList list = new ArrayList();
        for (Object o : listEntry) {
            HashMap<String, String> keyValuePairs = new HashMap<String, String>();
            if (o instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)o;
                for (Object column : columns) {
                    String value = ServletHelpers.removeNoisyString(jsonObject.get((Object)column.toString()));
                    keyValuePairs.put(column.toString(), value);
                }
            }
            list.add(keyValuePairs);
        }
        return list;
    }

    public static String generateCsvString(Map xlData) {
        int idx1 = 0;
        int idx2 = 0;
        StringBuffer buffer = new StringBuffer();
        Set columns = (Set)xlData.get("columns");
        List rows = (List)xlData.get("rows");
        for (Object column : columns) {
            buffer.append(ServletHelpers.wrapWithDoubleQuotes(column.toString()));
            buffer = ServletHelpers.appendComma(buffer, columns.size(), idx1);
            ++idx1;
        }
        idx1 = 0;
        buffer.append("\n");
        for (Object row : rows) {
            Map keyValuePair = (Map)row;
            for (Object column : columns) {
                buffer.append(ServletHelpers.wrapWithDoubleQuotes(keyValuePair.get(column.toString()).toString()));
                buffer = ServletHelpers.appendComma(buffer, columns.size(), idx2);
                ++idx2;
            }
            idx2 = 0;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String wrapWithDoubleQuotes(String string) {
        return "\"" + string + "\"";
    }

    private static StringBuffer appendComma(StringBuffer buffer, int size, int index) {
        return size == index + 1 ? buffer : buffer.append(",");
    }

    public static List flatten(List list) {
        ArrayList tempList = new ArrayList();
        for (Object o : list) {
            if (o instanceof Collection) {
                tempList.addAll((Collection)o);
                continue;
            }
            tempList.add(o);
        }
        return tempList;
    }

    public static Set flatten(Set set) {
        HashSet tempSet = new HashSet();
        for (Object o : tempSet) {
            if (o instanceof Collection) {
                tempSet.addAll((Collection)o);
                continue;
            }
            tempSet.add(o);
        }
        return tempSet;
    }

    public static String removeNoisyString(Object value) {
        String string = "";
        if (value != null) {
            string = value.toString().contains("@reference") ? "" : value.toString();
        }
        return string;
    }

    public static InputStream loadFile(String path) {
        if (path.startsWith("classpath:")) {
            String classPathLocation = path.substring(10);
            return ServletHelpers.class.getClassLoader().getResourceAsStream(classPathLocation);
        }
        try {
            if (!path.contains(":")) {
                path = "file://" + path;
            }
            return new URL(path).openStream();
        }
        catch (Exception e) {
            LOG.warn("Couldn't find keycloak config file on location: {}", (Object)path);
            LOG.debug("Couldn't find keycloak config file", (Throwable)e);
            return null;
        }
    }
}

