/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.ConfigManager;
import io.hawt.system.Helpers;
import io.hawt.util.Strings;
import io.hawt.web.RelativeRequestUri;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionExpiryFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(SessionExpiryFilter.class);
    private static final String[] ignoredPaths = new String[]{"jolokia", "proxy"};
    private List<String> ignoredPathList;
    private ServletContext context;
    private boolean noCredentials401;
    private int pathIndex;

    public void init(FilterConfig filterConfig) throws ServletException {
        String servletPath;
        this.ignoredPathList = Arrays.asList(ignoredPaths);
        this.context = filterConfig.getServletContext();
        ConfigManager config = (ConfigManager)this.context.getAttribute("ConfigManager");
        if (config != null) {
            this.noCredentials401 = Boolean.parseBoolean(config.get("noCredentials401", "false"));
        }
        this.pathIndex = (servletPath = (String)filterConfig.getServletContext().getAttribute("hawtioServletPath")) == null ? 0 : Strings.webContextPath((String)servletPath, (String[])new String[0]).replaceAll("[^/]+", "").length();
        if (System.getProperty("hawtio.noCredentials401") != null) {
            this.noCredentials401 = Boolean.getBoolean("hawtio.noCredentials401");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.process((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void writeOk(HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=UTF-8");
        try (ServletOutputStream out = response.getOutputStream();){
            out.write("ok".getBytes());
            out.flush();
        }
    }

    private void updateLastAccess(HttpSession session, long now) {
        session.setAttribute("LastAccess", (Object)now);
        LOG.debug("Reset LastAccess to: {}", (Object)now);
    }

    private void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.context == null || this.context.getAttribute("authenticationEnabled") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession(false);
        boolean enabled = (Boolean)this.context.getAttribute("authenticationEnabled");
        RelativeRequestUri uri = new RelativeRequestUri(request, this.pathIndex);
        LOG.debug("Accessing [{}], hawtio path is [{}]", (Object)request.getRequestURI(), (Object)uri.getUri());
        if (uri.getComponents().length == 0) {
            if (session != null) {
                long now = System.currentTimeMillis();
                this.updateLastAccess(session, now);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String subContext = uri.getComponents()[0];
        if (session == null || session.getMaxInactiveInterval() < 0) {
            if (subContext.equals("refresh") && !enabled) {
                LOG.debug("Authentication disabled, received refresh response, responding with ok");
                this.writeOk(response);
            } else if (!enabled) {
                LOG.debug("Authentication disabled, allowing request");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (request.getHeader("Authorization") != null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (this.noCredentials401 && subContext.equals("jolokia")) {
                LOG.debug("Authentication enabled, noCredentials401 is true, allowing request for {}", (Object)subContext);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (subContext.equals("jolokia") || subContext.equals("proxy") || subContext.equals("user") || subContext.equals("exportContext") || subContext.equals("contextFormatter") || subContext.equals("upload")) {
                LOG.debug("Authentication enabled, denying request for {}", (Object)subContext);
                Helpers.doForbidden(response);
            } else {
                LOG.debug("Authentication enabled, but allowing request for {}", (Object)subContext);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        int maxInactiveInterval = session.getMaxInactiveInterval();
        long now = System.currentTimeMillis();
        if (session.getAttribute("LastAccess") != null) {
            long lastAccess = (Long)session.getAttribute("LastAccess");
            long remainder = (now - lastAccess) / 1000L;
            LOG.debug("Session expiry: {}s, duration since last access: {}s", (Object)maxInactiveInterval, (Object)remainder);
            if (remainder > (long)maxInactiveInterval) {
                LOG.info("Expiring session due to inactivity");
                session.invalidate();
                Helpers.doForbidden(response);
                return;
            }
        }
        if (subContext.equals("refresh")) {
            this.updateLastAccess(session, now);
            this.writeOk(response);
            return;
        }
        LOG.debug("SubContext: {}", (Object)subContext);
        if (this.ignoredPathList.contains(subContext) && session.getAttribute("LastAccess") != null) {
            LOG.debug("Not updating LastAccess");
        } else {
            this.updateLastAccess(session, now);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

