/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.ConfigManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UserServlet
extends HttpServlet {
    protected ConfigManager config;
    private boolean authenticationEnabled = true;

    public void init() throws ServletException {
        this.config = (ConfigManager)this.getServletConfig().getServletContext().getAttribute("ConfigManager");
        if (this.config != null) {
            this.authenticationEnabled = Boolean.parseBoolean(this.config.get("authenticationEnabled", "true"));
        }
        if (System.getProperty("hawtio.authenticationEnabled") != null) {
            this.authenticationEnabled = Boolean.getBoolean("hawtio.authenticationEnabled");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        PrintWriter out = resp.getWriter();
        if (!this.authenticationEnabled) {
            out.write("\"user\"");
            out.flush();
            out.close();
            return;
        }
        String username = this.getUsername(req, resp);
        if (username != null) {
            out.write("\"" + username + "\"");
        } else {
            out.write("");
        }
        out.flush();
        out.close();
    }

    protected String getUsername(HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            return (String)session.getAttribute("user");
        }
        return null;
    }
}

