/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.keycloak;

import io.hawt.system.ConfigManager;
import io.hawt.util.IOHelper;
import io.hawt.web.ServletHelpers;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakServlet
extends HttpServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(KeycloakServlet.class);
    public static final String KEYCLOAK_CLIENT_CONFIG = "keycloakClientConfig";
    public static final String KEYCLOAK_ENABLED = "keycloakEnabled";
    public static final String HAWTIO_KEYCLOAK_CLIENT_CONFIG = "hawtio.keycloakClientConfig";
    public static final String HAWTIO_KEYCLOAK_ENABLED = "hawtio.keycloakEnabled";
    private String keycloakConfig = null;
    private boolean keycloakEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ConfigManager config = (ConfigManager)this.getServletContext().getAttribute("ConfigManager");
        this.keycloakEnabled = KeycloakServlet.isKeycloakEnabled(config);
        LOG.info("Keycloak integration is " + (this.keycloakEnabled ? "enabled" : "disabled"));
        if (!this.keycloakEnabled) {
            return;
        }
        String keycloakConfigFile = config.get(KEYCLOAK_CLIENT_CONFIG, null);
        if (System.getProperty(HAWTIO_KEYCLOAK_CLIENT_CONFIG) != null) {
            keycloakConfigFile = System.getProperty(HAWTIO_KEYCLOAK_CLIENT_CONFIG);
        }
        if (keycloakConfigFile == null || keycloakConfigFile.length() == 0) {
            keycloakConfigFile = this.defaultKeycloakConfigLocation();
        }
        LOG.info("Will load keycloak config from location: " + keycloakConfigFile);
        InputStream is = ServletHelpers.loadFile(keycloakConfigFile);
        if (is == null) {
            LOG.warn("Keycloak client configuration not found!");
        } else {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String keycloakConfig = IOHelper.readFully((BufferedReader)reader);
                this.keycloakConfig = keycloakConfig.replaceAll(" ", "").replaceAll(System.lineSeparator(), "");
            }
            catch (IOException ioe) {
                LOG.warn("Couldn't read keycloak configuration file", (Throwable)ioe);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"keycloakInputStream", (Logger)LOG);
            }
        }
    }

    public static boolean isKeycloakEnabled(ConfigManager config) {
        String keycloakEnabledCfg = config.get(KEYCLOAK_ENABLED, "false");
        if (System.getProperty(HAWTIO_KEYCLOAK_ENABLED) != null) {
            keycloakEnabledCfg = System.getProperty(HAWTIO_KEYCLOAK_ENABLED);
        }
        return Boolean.parseBoolean(keycloakEnabledCfg);
    }

    protected String defaultKeycloakConfigLocation() {
        String karafBase = System.getProperty("karaf.base");
        if (karafBase != null) {
            return karafBase + "/etc/keycloak.json";
        }
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null) {
            return jettyHome + "/etc/keycloak.json";
        }
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome != null) {
            return tomcatHome + "/conf/keycloak.json";
        }
        String jbossHome = System.getProperty("jboss.server.config.dir");
        if (jbossHome != null) {
            return jbossHome + "/keycloak.json";
        }
        return "classpath:keycloak.json";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if ("/enabled".equals(pathInfo)) {
            this.renderJSONResponse(response, String.valueOf(this.keycloakEnabled));
        } else if ("/client-config".equals(pathInfo)) {
            if (this.keycloakConfig == null) {
                response.sendError(404, "Keycloak client configuration not found");
            } else {
                this.renderJSONResponse(response, this.keycloakConfig);
            }
        } else if ("/validate-subject-matches".equals(pathInfo)) {
            String keycloakUser = request.getParameter("keycloakUser");
            if (keycloakUser == null || keycloakUser.length() == 0) {
                LOG.warn("Parameter 'keycloakUser' not found");
            }
            boolean valid = this.validateKeycloakUser(request, keycloakUser);
            this.renderJSONResponse(response, String.valueOf(valid));
        }
    }

    protected boolean validateKeycloakUser(HttpServletRequest request, String keycloakUser) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        String username = (String)session.getAttribute("user");
        if (username != null && !username.equals(keycloakUser)) {
            LOG.debug("Non matching username found. JAAS username: " + username + ", keycloakUsername: " + keycloakUser + ". Invalidating session");
            session.invalidate();
            return false;
        }
        return true;
    }

    private void renderJSONResponse(HttpServletResponse response, String text) throws ServletException, IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.println(text);
        writer.flush();
        writer.close();
    }
}

