/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.keycloak;

import io.hawt.system.Authenticator;
import io.hawt.system.Helpers;
import io.hawt.system.PrivilegedCallback;
import io.hawt.web.AuthenticationConfiguration;
import io.hawt.web.UserServlet;
import io.hawt.web.keycloak.KeycloakServlet;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KeycloakUserServlet
extends UserServlet {
    private boolean keycloakEnabled;

    @Override
    public void init() throws ServletException {
        super.init();
        this.keycloakEnabled = KeycloakServlet.isKeycloakEnabled(this.config);
    }

    @Override
    protected String getUsername(HttpServletRequest req, HttpServletResponse resp) {
        if (this.keycloakEnabled) {
            return this.getKeycloakUsername(req, resp);
        }
        return super.getUsername(req, resp);
    }

    protected String getKeycloakUsername(final HttpServletRequest req, HttpServletResponse resp) {
        AuthenticationConfiguration configuration = (AuthenticationConfiguration)this.getServletContext().getAttribute("authenticationConfig");
        class Holder {
            String username = null;

            Holder() {
            }
        }
        final Holder usernameHolder = new Holder();
        Authenticator.authenticate(configuration.getRealm(), configuration.getRole(), configuration.getRolePrincipalClasses(), configuration.getConfiguration(), req, new PrivilegedCallback(){
            {
            }

            @Override
            public void execute(Subject subject) throws Exception {
                usernameHolder.username = Helpers.getUsernameFromSubject(subject);
                req.getSession(true);
            }
        });
        return usernameHolder.username;
    }
}

