/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.logging.Log;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public abstract class FileChanges {
    private FileChanges() {
    }

    public static Optional<FileTime> changedSince(Path directory, FileTime baseTime, final Predicate<Path> dirFilter, final Predicate<Path> fileFilter, DetectionType type) {
        FileTime base = baseTime == null ? FileTime.fromMillis(0L) : baseTime;
        final AtomicReference<FileTime> checkTime = new AtomicReference<FileTime>(base);
        final AtomicReference changeTime = new AtomicReference();
        final boolean checkAllFiles = type == DetectionType.LATEST;
        Log.debug("Checking if project has files newer than last check time %s", checkTime.get());
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return dirFilter.test(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    FileTime fileTime;
                    if (fileFilter.test(file) && (fileTime = FileUtils.lastModifiedTime(file)).compareTo((FileTime)checkTime.get()) > 0) {
                        Log.debug("%s @ %s is newer than last check time %s", file, fileTime, checkTime.get());
                        changeTime.set(fileTime);
                        if (checkAllFiles) {
                            checkTime.set(fileTime);
                        } else {
                            return FileVisitResult.TERMINATE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    changeTime.set(null);
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            return Optional.ofNullable((FileTime)changeTime.get());
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), new Object[0]);
            return Optional.of(FileTime.fromMillis(System.currentTimeMillis()));
        }
    }

    public static enum DetectionType {
        FIRST,
        LATEST;

    }
}

