/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Permutations {
    private Permutations() {
    }

    public static <T> Stream<List<T>> ofList0(List<List<T>> lists) {
        ListIterator<T> iterator = new ListIterator<T>(lists);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 256), false);
    }

    public static <T> List<List<T>> ofList(List<List<T>> lists) {
        return Permutations.ofList0(lists).collect(Collectors.toList());
    }

    public static <T> List<List<T>> of(List<T> list) {
        if (list.size() >= 64) {
            throw new UnsupportedOperationException("list size >= 64");
        }
        int size = list.size();
        long len = 1L << size;
        LinkedList<List<T>> permutations = new LinkedList<List<T>>();
        permutations.add(List.of());
        for (long p = 1L; p < len; ++p) {
            LinkedList<T> permutation = new LinkedList<T>();
            for (int i = 0; i < size; ++i) {
                if ((1L << i & p) <= 0L) continue;
                permutation.add(list.get(i));
            }
            permutations.add(permutation);
        }
        return permutations;
    }

    public static class ListIterator<T>
    implements Iterator<List<T>> {
        private final List<List<T>> elements;
        private final BitSet bitSet = new BitSet();
        private boolean started;
        private List<T> permutation;

        public ListIterator(List<List<T>> elements) {
            this.elements = elements;
        }

        @Override
        public boolean hasNext() {
            if (this.started && this.bitSet.isEmpty()) {
                return false;
            }
            if (this.permutation != null) {
                return !this.permutation.isEmpty();
            }
            this.started = true;
            int offset = 0;
            int pOffset = 0;
            this.permutation = new LinkedList<T>();
            for (List<T> list : this.elements) {
                int size = list.size();
                if (size == 0) continue;
                int pos = this.bitSet.nextSetBit(offset);
                int rPos = pos - offset;
                if (rPos < 0 || rPos >= size) {
                    pos = offset;
                    this.bitSet.set(pos);
                }
                this.permutation.add(list.get(pos - offset));
                if (offset == 0 || offset > 0 && this.bitSet.previousSetBit(offset - 1) < pOffset) {
                    this.bitSet.clear(pos);
                    if (pos - offset + 1 < size) {
                        this.bitSet.set(pos + 1);
                    }
                }
                pOffset = offset;
                offset += size;
            }
            return !this.permutation.isEmpty();
        }

        @Override
        public List<T> next() {
            List<T> next = this.permutation;
            this.permutation = null;
            return next;
        }
    }
}

