/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.RichText;
import io.helidon.build.common.RichTextProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public interface RichTextStyle {
    public static final RichTextStyle NONE = new RichTextStyle(){};

    public static RichTextStyle of(RichTextStyle ... styles) {
        if (styles.length == 0) {
            return NONE;
        }
        if (styles.length == 1) {
            return styles[0];
        }
        return new StyleList(styles);
    }

    public static RichTextStyle of(String ... names) {
        return RichTextProvider.Holder.INSTANCE.styleOf(names);
    }

    default public RichText apply(RichText richText) {
        return richText;
    }

    default public String apply(Object text) {
        return this.apply(RichTextProvider.Holder.INSTANCE.richText()).append(String.valueOf(text)).reset().text();
    }

    default public RichText reset(RichText richText) {
        return richText;
    }

    public static class StyleList
    implements RichTextStyle {
        private final List<RichTextStyle> styles = new ArrayList<RichTextStyle>();

        public StyleList(String ... names) {
            for (String name : names) {
                this.add(name);
            }
        }

        @SafeVarargs
        public <T> StyleList(Function<T, RichTextStyle> function, T ... objects) {
            for (T obj : objects) {
                this.add(function.apply(obj));
            }
        }

        public StyleList(RichTextStyle ... styles) {
            for (RichTextStyle style : styles) {
                this.add(style);
            }
        }

        public StyleList add(String name) {
            this.add(RichTextProvider.Holder.INSTANCE.styleOf(name));
            return this;
        }

        public StyleList add(RichTextStyle style) {
            this.styles.add(style);
            return this;
        }

        public int size() {
            return this.styles.size();
        }

        public RichTextStyle pop() {
            if (this.styles.isEmpty()) {
                return NONE;
            }
            return this.styles.remove(this.size() - 1);
        }

        @Override
        public RichText apply(RichText ansi) {
            for (RichTextStyle style : this.styles) {
                style.apply(ansi);
            }
            return ansi;
        }

        @Override
        public RichText reset(RichText ansi) {
            return ansi.reset();
        }

        public String toString() {
            return this.styles.toString();
        }
    }
}

