/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static boolean isValid(String value) {
        return value != null && !value.isBlank();
    }

    public static String requireValid(String value, String message) {
        if (Strings.isNotValid(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static boolean isNotValid(String value) {
        return value == null || value.isBlank();
    }

    public static String normalizeNewLines(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("\r\n", "\n");
    }

    public static String normalizePath(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\\", "/");
    }

    public static String read(InputStream inputStream) {
        try {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String padding(String pad, int maxKeyWidth, String key) {
        int keyLen = key.length();
        if (maxKeyWidth > keyLen) {
            return pad.repeat(maxKeyWidth - keyLen);
        }
        return "";
    }

    public static String stripLeading(String str, char c) {
        int index = 0;
        while (index < str.length() && str.charAt(index++) == c) {
        }
        if (index == str.length()) {
            return "";
        }
        return str.substring(index - 1);
    }

    private Strings() {
    }
}

