/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import io.helidon.build.common.RichTextStyle;
import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.LogFormatter;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.logging.LogWriter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Log {
    private static final String PAD = " ";
    private static final AtomicInteger MESSAGES = new AtomicInteger();
    private static final AtomicInteger WARNINGS = new AtomicInteger();
    private static final AtomicInteger ERRORS = new AtomicInteger();

    private Log() {
    }

    public static int messages() {
        return MESSAGES.get();
    }

    public static int warnings() {
        return WARNINGS.get();
    }

    public static int errors() {
        return ERRORS.get();
    }

    public static void debug(String message, Object ... args) {
        Log.log(LogLevel.DEBUG, message, args);
    }

    public static void verbose(String message, Object ... args) {
        Log.log(LogLevel.VERBOSE, message, args);
    }

    public static void info() {
        Log.log(LogLevel.INFO, "", new Object[0]);
    }

    public static void info(String message, Object ... args) {
        Log.log(LogLevel.INFO, message, args);
    }

    public static void warn(String message, Object ... args) {
        Log.log(LogLevel.WARN, message, args);
    }

    public static void warn(Throwable thrown, String msg, Object ... args) {
        Log.log(LogLevel.WARN, thrown, msg, args);
    }

    public static void error(String message, Object ... args) {
        Log.log(LogLevel.ERROR, message, args);
    }

    public static void error(Throwable thrown, String message, Object ... args) {
        Log.log(LogLevel.ERROR, thrown, message, args);
    }

    public static void log(LogLevel level, String message, Object ... args) {
        Log.log(level, null, message, args);
    }

    public static void log(LogLevel level, Map<Object, Object> map, RichTextStyle keyStyle, RichTextStyle valueStyle) {
        Log.log(level, map, Log.maxKeyWidth(map), keyStyle, valueStyle);
    }

    public static void log(LogLevel level, Map<Object, Object> map, int maxKeyWidth, RichTextStyle keyStyle, RichTextStyle valueStyle) {
        if (!map.isEmpty()) {
            map.forEach((key, value) -> {
                String padding = Strings.padding(PAD, maxKeyWidth, key.toString());
                Log.log(level, "%s %s %s", keyStyle.apply(key), padding, valueStyle.apply(value));
            });
        }
    }

    public static void log(LogLevel level, Throwable thrown, String message, Object ... args) {
        MESSAGES.incrementAndGet();
        if (level == LogLevel.WARN) {
            WARNINGS.incrementAndGet();
        } else if (level == LogLevel.ERROR) {
            ERRORS.incrementAndGet();
        }
        if (message == null) {
            message = "<null>";
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "<null>";
            }
        }
        LogWriter.write(level, thrown, message, args);
    }

    @SafeVarargs
    public static int maxKeyWidth(Map<Object, Object> ... maps) {
        int maxLen = 0;
        for (Map<Object, Object> map : maps) {
            for (Object key : map.keySet()) {
                int len = key.toString().length();
                if (len <= maxLen) continue;
                maxLen = len;
            }
        }
        return maxLen;
    }

    static {
        LogWriter.init();
        LogFormatter.init();
    }
}

