/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import io.helidon.build.common.logging.DefaultFormatter;
import io.helidon.build.common.logging.LogLevel;
import java.util.ServiceLoader;
import java.util.function.Function;

public abstract class LogFormatter {
    public abstract String formatEntry(LogLevel var1, Throwable var2, String var3, Object ... var4);

    public static Function<String, String> of(LogLevel level) {
        return msg -> Holder.INSTANCE.formatEntry(level, null, (String)msg, new Object[0]);
    }

    public static String format(LogLevel level, Throwable thrown, String message, Object ... args) {
        return Holder.INSTANCE.formatEntry(level, thrown, message, args);
    }

    public static boolean isDebug(LogLevel level) {
        return LogLevel.DEBUG.ordinal() >= level.ordinal();
    }

    public static boolean isVerbose(LogLevel level) {
        return LogLevel.VERBOSE.ordinal() >= level.ordinal();
    }

    static void init() throws IllegalStateException {
        if (Holder.INSTANCE == null) {
            throw new IllegalStateException("Unable to load log formatter");
        }
    }

    private static final class Holder {
        static final LogFormatter INSTANCE = ServiceLoader.load(LogFormatter.class, LogFormatter.class.getClassLoader()).findFirst().orElse(DefaultFormatter.INSTANCE);

        private Holder() {
        }
    }
}

