/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import java.util.LinkedList;
import java.util.List;

public class LogRecorder {
    private static final String EOL = System.getProperty("line.separator");
    private final List<String> entries = new LinkedList<String>();

    private LogRecorder() {
    }

    public static LogRecorder create() {
        return new LogRecorder();
    }

    public void addEntry(String entry) {
        this.entries.add(entry);
    }

    public void clear() {
        this.entries.clear();
    }

    public List<String> entries() {
        return this.entries;
    }

    public String output() {
        String output = String.join((CharSequence)EOL, this.entries());
        if (output.length() > 0) {
            return output + EOL;
        }
        return output;
    }

    public int size() {
        return this.entries.size();
    }
}

