/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.linker;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.InputStreams;
import io.helidon.build.common.OSType;
import io.helidon.build.common.PrintStreams;
import io.helidon.build.common.ProcessMonitor;
import io.helidon.build.common.logging.Log;
import io.helidon.build.common.logging.LogFormatter;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.linker.StartScriptTemplate;
import io.helidon.build.linker.util.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.IntStream;

public class StartScript {
    public static final String SCRIPT_FILE_NAME = Constants.OS.withScriptExtension("start");
    private final Path installDirectory;
    private final Path scriptFile;
    private final String script;
    private final int maxAppStartSeconds;

    static Builder builder() {
        return new Builder();
    }

    private StartScript(Builder builder) {
        this.installDirectory = builder.scriptInstallDirectory;
        this.scriptFile = builder.scriptFile;
        this.script = builder.script;
        this.maxAppStartSeconds = builder.maxAppStartSeconds;
    }

    Path installDirectory() {
        return this.installDirectory;
    }

    Path install() {
        try {
            Files.copy(new ByteArrayInputStream(this.script.getBytes(StandardCharsets.UTF_8)), this.scriptFile, new CopyOption[0]);
            if (Constants.OS.isPosix()) {
                Files.setPosixFilePermissions(this.scriptFile, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE));
            }
            return this.scriptFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void execute(Function<String, String> transform, String ... args) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> command = new ArrayList<String>();
        Path root = Objects.requireNonNull(Objects.requireNonNull(this.scriptFile.getParent()).getParent());
        if (Constants.OS.scriptExecutor() != null) {
            command.add(Constants.OS.scriptExecutor());
        }
        command.add(this.scriptFile.toString());
        command.addAll(Arrays.asList(args));
        Log.debug((String)"Commands: %s", (Object[])new Object[]{((Object)command).toString()});
        processBuilder.command(command);
        processBuilder.directory(root.toFile());
        ProcessMonitor monitor = ProcessMonitor.builder().processBuilder(processBuilder).stdOut(PrintStreams.apply((PrintStream)PrintStreams.STDOUT, (Function)LogFormatter.of((LogLevel)LogLevel.INFO))).stdErr(PrintStreams.apply((PrintStream)PrintStreams.STDERR, (Function)LogFormatter.of((LogLevel)LogLevel.WARN))).transform(transform).capture(true).build();
        try {
            monitor.execute((long)this.maxAppStartSeconds, TimeUnit.SECONDS);
            this.checkWindowsExecutionPolicyError(monitor, false);
        }
        catch (ProcessMonitor.ProcessFailedException e) {
            this.checkWindowsExecutionPolicyError(e.monitor(), true);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkWindowsExecutionPolicyError(ProcessMonitor monitor, boolean failed) {
        if (Constants.OS == OSType.Windows) {
            String stdErr = String.join((CharSequence)" ", monitor.stdErr());
            if (failed || stdErr.contains("FullyQualifiedErrorId")) {
                StringBuilder msg = new StringBuilder();
                msg.append("Generated ").append(this.scriptFile.getFileName()).append(" script failed.");
                if (StartScript.containsAll(stdErr, Constants.WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR)) {
                    msg.append(Constants.WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR_HELP);
                }
                throw new RuntimeException(msg.toString());
            }
        }
    }

    public String script() {
        return this.script;
    }

    public Path scriptFile() {
        return this.scriptFile;
    }

    public String toString() {
        return this.script;
    }

    private static boolean containsAll(String message, List<String> words) {
        for (String word : words) {
            if (message.contains(word)) continue;
            return false;
        }
        return true;
    }

    public static final class Builder {
        private Path installHomeDirectory;
        private Path scriptInstallDirectory;
        private Path mainJar;
        private List<String> defaultJvmOptions = Collections.emptyList();
        private List<String> defaultDebugOptions = List.of("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5005");
        private List<String> defaultArgs = Collections.emptyList();
        private boolean cdsInstalled = true;
        private boolean debugInstalled = true;
        private String exitOnStartedValue = "!";
        private Template template;
        private TemplateConfig config;
        private Path scriptFile;
        private String script;
        private int maxAppStartSeconds = 1000;

        private Builder() {
        }

        public Builder installHomeDirectory(Path installHomeDirectory) {
            this.installHomeDirectory = FileUtils.requireDirectory((Path)installHomeDirectory);
            this.scriptInstallDirectory = FileUtils.requireDirectory((Path)installHomeDirectory).resolve("bin");
            return this;
        }

        public Builder mainJar(Path mainJar) {
            this.mainJar = FileUtils.requireFile((Path)mainJar);
            return this;
        }

        public Builder defaultJvmOptions(List<String> jvmOptions) {
            if (Builder.hasContent(jvmOptions)) {
                this.defaultJvmOptions = jvmOptions;
            }
            return this;
        }

        public Builder defaultArgs(List<String> args) {
            if (Builder.hasContent(args)) {
                this.defaultArgs = args;
            }
            return this;
        }

        public Builder defaultDebugOptions(List<String> debugOptions) {
            if (Builder.hasContent(debugOptions)) {
                this.defaultDebugOptions = debugOptions;
            }
            return this;
        }

        public Builder cdsInstalled(boolean cdsInstalled) {
            this.cdsInstalled = cdsInstalled;
            return this;
        }

        public Builder debugInstalled(boolean debugInstalled) {
            this.debugInstalled = debugInstalled;
            return this;
        }

        public Builder exitOnStartedValue(String exitOnStartedValue) {
            this.exitOnStartedValue = Objects.requireNonNull(exitOnStartedValue);
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public Builder maxAppStartSeconds(int maxAppStartSeconds) {
            this.maxAppStartSeconds = maxAppStartSeconds;
            return this;
        }

        public StartScript build() {
            if (this.installHomeDirectory == null) {
                throw new IllegalStateException("installHomeDirectory is required");
            }
            if (this.mainJar == null) {
                throw new IllegalStateException("mainJar is required");
            }
            this.scriptFile = this.scriptInstallDirectory.resolve(SCRIPT_FILE_NAME);
            this.config = this.toConfig();
            this.script = this.template().render(this.config);
            return new StartScript(this);
        }

        private Template template() {
            if (this.template == null) {
                if (Constants.OS == OSType.Unknown) {
                    throw new PlatformNotSupportedError(this.config.toCommand());
                }
                return new StartScriptTemplate();
            }
            return this.template;
        }

        private TemplateConfig toConfig() {
            return new TemplateConfig(){

                @Override
                public Path installHomeDirectory() {
                    return installHomeDirectory;
                }

                @Override
                public Path scriptInstallDirectory() {
                    return scriptInstallDirectory;
                }

                @Override
                public Path mainJar() {
                    return mainJar;
                }

                @Override
                public List<String> defaultJvmOptions() {
                    return defaultJvmOptions;
                }

                @Override
                public List<String> defaultDebugOptions() {
                    return defaultDebugOptions;
                }

                @Override
                public List<String> defaultArgs() {
                    return defaultArgs;
                }

                @Override
                public boolean cdsInstalled() {
                    return cdsInstalled;
                }

                @Override
                public boolean debugInstalled() {
                    return debugInstalled;
                }

                @Override
                public String exitOnStartedValue() {
                    return exitOnStartedValue;
                }
            };
        }

        private static boolean hasContent(Collection<?> value) {
            return value != null && !value.isEmpty();
        }
    }

    public static abstract class SimpleTemplate
    implements Template {
        private final List<String> template;

        protected SimpleTemplate(String templateResourcePath) {
            this(SimpleTemplate.load(templateResourcePath));
        }

        protected SimpleTemplate(List<String> template) {
            this.template = template;
        }

        protected void removeLines(String substring, boolean ignoreCase) {
            this.removeLines((index, line) -> SimpleTemplate.contains(line, substring, ignoreCase));
        }

        protected void removeLines(BiPredicate<Integer, String> predicate) {
            for (int i = this.template.size() - 1; i >= 0; --i) {
                if (!predicate.test(i, this.template.get(i))) continue;
                this.template.remove(i);
            }
        }

        protected int indexOf(int startIndex, String substring, boolean ignoreCase) {
            return this.indexOf(startIndex, (index, line) -> SimpleTemplate.contains(line, substring, ignoreCase));
        }

        protected int indexOfEquals(int startIndex, String str) {
            return this.indexOf(startIndex, (index, line) -> line.equals(str));
        }

        protected int indexOf(int startIndex, BiPredicate<Integer, String> predicate) {
            return IntStream.range(startIndex, this.template.size()).filter(index -> predicate.test(index, this.template.get(index))).findFirst().orElseThrow(IllegalStateException::new);
        }

        protected void replace(String substring, String replacement) {
            for (int i = 0; i < this.template.size(); ++i) {
                this.template.set(i, this.template.get(i).replace(substring, replacement));
            }
        }

        protected static String lastModifiedTime(Path file) {
            return Long.toString(FileUtils.lastModifiedSeconds((Path)file));
        }

        public String toString() {
            return String.join((CharSequence)Constants.EOL, this.template);
        }

        private static boolean contains(String line, String substring, boolean ignoreCase) {
            return ignoreCase ? line.toLowerCase().contains(substring) : line.contains(substring);
        }

        private static List<String> load(String resourcePath) {
            InputStream content = SimpleTemplate.class.getClassLoader().getResourceAsStream(resourcePath);
            if (content == null) {
                throw new IllegalStateException(resourcePath + " not found");
            }
            try {
                return InputStreams.toLines((InputStream)content);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static interface Template {
        public String render(TemplateConfig var1);
    }

    public static interface TemplateConfig {
        public Path installHomeDirectory();

        public Path scriptInstallDirectory();

        public Path mainJar();

        public List<String> defaultJvmOptions();

        public List<String> defaultDebugOptions();

        public List<String> defaultArgs();

        public boolean cdsInstalled();

        public boolean debugInstalled();

        public String exitOnStartedValue();

        default public boolean cdsRequiresUnlock() {
            return this.cdsInstalled() && Constants.CDS_REQUIRES_UNLOCK_OPTION;
        }

        default public boolean cdsSupportsImageCopy() {
            return this.cdsInstalled() && Constants.CDS_SUPPORTS_IMAGE_COPY;
        }

        default public List<String> toCommand() {
            ArrayList<String> command = new ArrayList<String>();
            command.add("bin" + Constants.DIR_SEP + "java");
            if (this.cdsInstalled()) {
                if (this.cdsRequiresUnlock()) {
                    command.add("-XX:+UnlockDiagnosticVMOptions");
                }
                command.add("-XX:SharedArchiveFile=lib" + Constants.DIR_SEP + "start.jsa");
                command.add("-Xshare:auto");
            }
            command.addAll(this.defaultJvmOptions());
            command.add("-jar");
            command.add("app" + Constants.DIR_SEP + this.mainJar().getFileName());
            command.addAll(this.defaultArgs());
            return command;
        }
    }

    public static final class PlatformNotSupportedError
    extends IllegalStateException {
        private final List<String> command;

        private PlatformNotSupportedError(List<String> command) {
            this.command = command;
        }

        List<String> command() {
            return this.command;
        }
    }
}

