/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.context;

import io.helidon.common.context.ListContext;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public interface Context {
    public static Context create() {
        return Context.builder().build();
    }

    public static Context create(Context parent) {
        return Context.builder().parent(parent).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> void register(T var1);

    public <T> void supply(Class<T> var1, Supplier<T> var2);

    public <T> Optional<T> get(Class<T> var1);

    public <T> void register(Object var1, T var2);

    public <T> void supply(Object var1, Class<T> var2, Supplier<T> var3);

    public <T> Optional<T> get(Object var1, Class<T> var2);

    public String id();

    public static class Builder
    implements io.helidon.common.Builder<Context> {
        private static final AtomicLong PARENT_CONTEXT_COUNTER = new AtomicLong(1L);
        private Context parent;
        private String id;

        public Context build() {
            if (null == this.id) {
                this.id = this.generateId();
            }
            return new ListContext(this);
        }

        private String generateId() {
            if (null == this.parent) {
                return String.valueOf(PARENT_CONTEXT_COUNTER.getAndIncrement());
            }
            if (this.parent instanceof ListContext) {
                return this.parent.id() + ":" + ((ListContext)this.parent).contextCounter().getAndIncrement();
            }
            return this.parent.id() + ":" + UUID.randomUUID();
        }

        public Builder parent(Context parent) {
            this.parent = parent;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        Context parent() {
            return this.parent;
        }

        String id() {
            return this.id;
        }
    }
}

