/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.context;

import io.helidon.common.context.Context;
import io.helidon.common.context.ContextAwareExecutorImpl;
import io.helidon.common.context.ContextAwareScheduledExecutorImpl;
import io.helidon.common.context.ExecutorException;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public final class Contexts {
    private static final ThreadLocal<Stack<Context>> REGISTRY = ThreadLocal.withInitial(Stack::new);

    private Contexts() {
    }

    static void clear() {
        REGISTRY.get().clear();
    }

    static void push(Context context) {
        REGISTRY.get().push(context);
    }

    static Context pop() {
        return REGISTRY.get().pop();
    }

    public static Optional<Context> context() {
        Stack<Context> contextStack = REGISTRY.get();
        if (contextStack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(contextStack.peek());
    }

    public static ExecutorService wrap(ExecutorService toWrap) {
        if (toWrap instanceof ContextAwareExecutorImpl) {
            return toWrap;
        }
        return new ContextAwareExecutorImpl(toWrap);
    }

    public static ScheduledExecutorService wrap(ScheduledExecutorService toWrap) {
        if (toWrap instanceof ContextAwareScheduledExecutorImpl) {
            return toWrap;
        }
        return new ContextAwareScheduledExecutorImpl(toWrap);
    }

    public static void runInContext(Context context, Runnable runnable) {
        Contexts.push(context);
        try {
            runnable.run();
        }
        finally {
            Contexts.pop();
        }
    }

    public static <T> T runInContext(Context context, Callable<T> callable) {
        Contexts.push(context);
        try {
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException("Callable.call failed", e);
        }
        finally {
            Contexts.pop();
        }
    }

    public static <T> T runInContextWithThrow(Context context, Callable<T> callable) throws Exception {
        Contexts.push(context);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            Contexts.pop();
        }
    }
}

