/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.Pausable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class PausableRegistry<T>
implements Pausable {
    private static final Logger LOGGER = Logger.getLogger(PausableRegistry.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private volatile BiConsumer<T, Pausable> onData;
    private volatile Consumer<Throwable> onError;
    private volatile Runnable onComplete;
    private volatile boolean paused = false;
    private boolean processing = false;

    PausableRegistry() {
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.tryProcess();
    }

    protected abstract void tryProcess();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
        Objects.requireNonNull(onData, "Parameter onData is null!");
        PausableRegistry pausableRegistry = this;
        synchronized (pausableRegistry) {
            if (this.onData != null) {
                throw new IllegalStateException("Handler is already registered!");
            }
            this.onData = onData;
            this.onError = onError;
            this.onComplete = onComplete;
        }
        this.resume();
    }

    protected boolean canProcess() {
        if (this.onData == null) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.paused || this.processing) {
                boolean bl = false;
                return bl;
            }
            this.processing = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean canContinueProcessing() {
        if (this.paused) {
            this.lock.lock();
            try {
                this.processing = false;
            }
            finally {
                this.lock.unlock();
            }
            return false;
        }
        return true;
    }

    protected boolean paused() {
        return this.paused;
    }

    protected void releaseProcessing() {
        this.lock.lock();
        try {
            this.processing = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void handleError(Throwable thr) {
        if (this.onError != null) {
            this.onError.accept(thr);
        } else {
            LOGGER.log(Level.WARNING, "Unhandled throwable!", thr);
        }
    }

    protected BiConsumer<T, Pausable> getOnData() {
        return this.onData;
    }

    protected Consumer<Throwable> getOnError() {
        return this.onError;
    }

    protected Runnable getOnComplete() {
        return this.onComplete;
    }
}

