/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.valve.DetachedValve;
import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.UnorderedCollectorSupport;
import io.helidon.common.reactive.valve.ValveFilter;
import io.helidon.common.reactive.valve.ValveIterator;
import io.helidon.common.reactive.valve.ValvePublisher;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;

public interface Valve<T>
extends Pausable {
    public void handle(BiConsumer<T, Pausable> var1, Consumer<Throwable> var2, Runnable var3);

    default public void handle(BiConsumer<T, Pausable> onData) {
        this.handle(onData, null, null);
    }

    default public void handle(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError) {
        this.handle(onData, onError, null);
    }

    default public void handle(Consumer<T> onData, Consumer<Throwable> onError, Runnable onComplete) {
        this.handle((T t, Pausable p) -> onData.accept(t), onError, onComplete);
    }

    default public void handle(Consumer<T> onData) {
        this.handle(onData, null, null);
    }

    default public void handle(Consumer<T> onData, Consumer<Throwable> onError) {
        this.handle(onData, onError, null);
    }

    default public <K> Valve<K> map(Function<T, K> mapper) {
        return new ValveFilter(this, onData -> (t, p) -> onData.accept(mapper.apply(t), p));
    }

    default public <K> Valve<K> flatMap(Function<T, Valve<K>> mapFunction) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    default public Valve<T> filter(Predicate<T> predicate) {
        return new ValveFilter(this, onData -> (t, p) -> {
            if (predicate.test(t)) {
                onData.accept(t, p);
            }
        });
    }

    default public Valve<T> peek(Consumer<T> action) {
        return new ValveFilter(this, onData -> (element, p) -> {
            action.accept(element);
            onData.accept(element, p);
        });
    }

    default public <A, R> CompletionStage<R> collect(Collector<? super T, A, R> collector) {
        Set<Collector.Characteristics> characteristics = collector.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.CONCURRENT)) {
            Object intermediateCollection = collector.supplier().get();
            BiConsumer accumulator = collector.accumulator();
            CompletableFuture result = new CompletableFuture();
            this.handle((T item) -> accumulator.accept(intermediateCollection, (Object)item), result::completeExceptionally, () -> result.complete(collector.finisher().apply(intermediateCollection)));
            return result;
        }
        if (characteristics.contains((Object)Collector.Characteristics.UNORDERED)) {
            UnorderedCollectorSupport<T, A, R> support = new UnorderedCollectorSupport<T, A, R>(collector);
            this.handle(support::add, support::completeExceptionally, support::complete);
            return support.getResult();
        }
        Object intermediateCollection = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        CompletableFuture result = new CompletableFuture();
        this.handle((T item) -> {
            Object object = intermediateCollection;
            synchronized (object) {
                accumulator.accept(intermediateCollection, (Object)item);
            }
        }, result::completeExceptionally, () -> result.complete(collector.finisher().apply(intermediateCollection)));
        return result;
    }

    default public Flow.Publisher<T> toPublisher() {
        return new ValvePublisher(this);
    }

    default public Valve<T> executeOn(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "Parameter 'executorService' is null!");
        return new DetachedValve(this, executorService);
    }

    default public ValveIterator<T> toIterator() {
        return new ValveIterator(this);
    }
}

