/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import java.util.Objects;
import java.util.concurrent.Flow;

final class MultiError<T>
implements Multi<T> {
    private final Throwable error;

    private MultiError(Throwable error) {
        this.error = Objects.requireNonNull(error, "error");
    }

    static <T> MultiError<T> create(Throwable error) {
        return new MultiError<T>(error);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(EmptySubscription.INSTANCE);
        subscriber.onError(this.error);
    }

    Throwable getError() {
        return this.error;
    }
}

