/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.ConsumerChain;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.RunnableChain;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public final class MultiTappedPublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Consumer<? super Flow.Subscription> onSubscribeCallback;
    private final Consumer<? super T> onNextCallback;
    private final Consumer<? super Throwable> onErrorCallback;
    private final Runnable onCompleteCallback;
    private final LongConsumer onRequestCallback;
    private final Runnable onCancelCallback;

    MultiTappedPublisher(Multi<T> source, Consumer<? super Flow.Subscription> onSubscribeCallback, Consumer<? super T> onNextCallback, Consumer<? super Throwable> onErrorCallback, Runnable onCompleteCallback, LongConsumer onRequestCallback, Runnable onCancelCallback) {
        this.source = source;
        this.onSubscribeCallback = onSubscribeCallback;
        this.onNextCallback = onNextCallback;
        this.onErrorCallback = onErrorCallback;
        this.onCompleteCallback = onCompleteCallback;
        this.onRequestCallback = onRequestCallback;
        this.onCancelCallback = onCancelCallback;
    }

    private MultiTappedPublisher(Builder<T> builder) {
        this(builder.source, builder.onSubscribeCallback, builder.onNextCallback, builder.onErrorCallback, builder.onCompleteCallback, builder.onRequestCallback, builder.onCancelCallback);
    }

    public static <T> Builder<T> builder(Multi<T> source) {
        return new Builder<T>(source);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new MultiTappedSubscriber<T>(subscriber, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback));
    }

    @Override
    public Multi<T> onComplete(Runnable onTerminate) {
        return new MultiTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, RunnableChain.combine(this.onCompleteCallback, onTerminate), this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Multi<T> onError(Consumer<? super Throwable> onErrorConsumer) {
        return new MultiTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, ConsumerChain.combine(this.onErrorCallback, onErrorConsumer), this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Multi<T> onTerminate(Runnable onTerminate) {
        return new MultiTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, ConsumerChain.combine(this.onErrorCallback, e -> onTerminate.run()), RunnableChain.combine(this.onCompleteCallback, onTerminate), this.onRequestCallback, RunnableChain.combine(this.onCancelCallback, onTerminate));
    }

    @Override
    public Multi<T> peek(Consumer<? super T> consumer) {
        return new MultiTappedPublisher<T>(this.source, this.onSubscribeCallback, ConsumerChain.combine(this.onNextCallback, consumer), this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Multi<T> onCancel(Runnable onCancel) {
        return new MultiTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, RunnableChain.combine(this.onCancelCallback, onCancel));
    }

    public static class Builder<T>
    implements io.helidon.common.Builder<MultiTappedPublisher<T>> {
        private final Multi<T> source;
        private Consumer<? super Flow.Subscription> onSubscribeCallback;
        private Consumer<? super T> onNextCallback;
        private Runnable onCompleteCallback;
        private LongConsumer onRequestCallback;
        private Runnable onCancelCallback;
        private Consumer<? super Throwable> onErrorCallback;

        private Builder(Multi<T> source) {
            this.source = source;
        }

        public MultiTappedPublisher<T> build() {
            return new MultiTappedPublisher(this);
        }

        Builder<T> onSubscribeCallback(Consumer<? super Flow.Subscription> onSubscribeCallback) {
            this.onSubscribeCallback = onSubscribeCallback;
            return this;
        }

        public Builder<T> onSubscribeCallback(Runnable onSubscribeCallback) {
            this.onSubscribeCallback = subscription -> onSubscribeCallback.run();
            return this;
        }

        public Builder<T> onNextCallback(Consumer<? super T> onNextCallback) {
            this.onNextCallback = onNextCallback;
            return this;
        }

        public Builder<T> onCompleteCallback(Runnable onCompleteCallback) {
            this.onCompleteCallback = onCompleteCallback;
            return this;
        }

        public Builder<T> onRequestCallback(LongConsumer onRequestCallback) {
            this.onRequestCallback = onRequestCallback;
            return this;
        }

        public Builder<T> onCancelCallback(Runnable onCancelCallback) {
            this.onCancelCallback = onCancelCallback;
            return this;
        }

        public Builder<T> onErrorCallback(Consumer<? super Throwable> onErrorCallback) {
            this.onErrorCallback = onErrorCallback;
            return this;
        }
    }

    static final class MultiTappedSubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Consumer<? super Flow.Subscription> onSubscribeCallback;
        private final Consumer<? super T> onNextCallback;
        private final Consumer<? super Throwable> onErrorCallback;
        private final Runnable onCompleteCallback;
        private final LongConsumer onRequestCallback;
        private final Runnable onCancelCallback;
        private Flow.Subscription upstream;
        private boolean suppressUpstream;

        MultiTappedSubscriber(Flow.Subscriber<? super T> downstream, Consumer<? super Flow.Subscription> onSubscribeCallback, Consumer<? super T> onNextCallback, Consumer<? super Throwable> onErrorCallback, Runnable onCompleteCallback, LongConsumer onRequestCallback, Runnable onCancelCallback) {
            this.downstream = downstream;
            this.onSubscribeCallback = onSubscribeCallback;
            this.onNextCallback = onNextCallback;
            this.onErrorCallback = onErrorCallback;
            this.onCompleteCallback = onCompleteCallback;
            this.onRequestCallback = onRequestCallback;
            this.onCancelCallback = onCancelCallback;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription is null");
            if (this.upstream != null) {
                subscription.cancel();
                return;
            }
            this.upstream = subscription;
            if (this.onSubscribeCallback != null) {
                try {
                    this.onSubscribeCallback.accept(subscription);
                }
                catch (Throwable ex) {
                    this.upstream = SubscriptionHelper.CANCELED;
                    subscription.cancel();
                    this.downstream.onSubscribe(this);
                    this.onError(ex);
                    return;
                }
            }
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            if (this.suppressUpstream) {
                return;
            }
            if (this.onNextCallback != null) {
                try {
                    this.onNextCallback.accept(item);
                }
                catch (Throwable ex) {
                    this.upstream.cancel();
                    this.onError(ex);
                    return;
                }
            }
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.suppressUpstream) {
                return;
            }
            this.suppressUpstream = true;
            if (this.onErrorCallback != null) {
                try {
                    this.onErrorCallback.accept(throwable);
                }
                catch (Throwable exc) {
                    throwable.addSuppressed(exc);
                }
            }
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.suppressUpstream) {
                return;
            }
            if (this.onCompleteCallback != null) {
                try {
                    this.onCompleteCallback.run();
                }
                catch (Throwable exc) {
                    this.onError(exc);
                    return;
                }
            }
            this.suppressUpstream = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (this.onRequestCallback != null) {
                try {
                    this.onRequestCallback.accept(n);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            if (this.onCancelCallback != null) {
                try {
                    this.onCancelCallback.run();
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }
            this.upstream.cancel();
        }

        void fail(Throwable ex) {
            if (this.onErrorCallback != null) {
                try {
                    this.onErrorCallback.accept(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

