/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.ConsumerChain;
import io.helidon.common.reactive.MultiTappedPublisher;
import io.helidon.common.reactive.RunnableChain;
import io.helidon.common.reactive.Single;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

final class SingleTappedPublisher<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Consumer<? super Flow.Subscription> onSubscribeCallback;
    private final Consumer<? super T> onNextCallback;
    private final Consumer<? super Throwable> onErrorCallback;
    private final Runnable onCompleteCallback;
    private final LongConsumer onRequestCallback;
    private final Runnable onCancelCallback;

    SingleTappedPublisher(Single<T> source, Consumer<? super Flow.Subscription> onSubscribeCallback, Consumer<? super T> onNextCallback, Consumer<? super Throwable> onErrorCallback, Runnable onCompleteCallback, LongConsumer onRequestCallback, Runnable onCancelCallback) {
        this.source = source;
        this.onSubscribeCallback = onSubscribeCallback;
        this.onNextCallback = onNextCallback;
        this.onErrorCallback = onErrorCallback;
        this.onCompleteCallback = onCompleteCallback;
        this.onRequestCallback = onRequestCallback;
        this.onCancelCallback = onCancelCallback;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new MultiTappedPublisher.MultiTappedSubscriber<T>(subscriber, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback));
    }

    @Override
    public Single<T> onComplete(Runnable onTerminate) {
        return new SingleTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, RunnableChain.combine(this.onCompleteCallback, onTerminate), this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Single<T> onError(Consumer<? super Throwable> onErrorConsumer) {
        return new SingleTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, ConsumerChain.combine(this.onErrorCallback, onErrorConsumer), this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Single<T> onTerminate(Runnable onTerminate) {
        return new SingleTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, ConsumerChain.combine(this.onErrorCallback, e -> onTerminate.run()), RunnableChain.combine(this.onCompleteCallback, onTerminate), this.onRequestCallback, RunnableChain.combine(this.onCancelCallback, onTerminate));
    }

    @Override
    public Single<T> peek(Consumer<? super T> consumer) {
        return new SingleTappedPublisher<T>(this.source, this.onSubscribeCallback, ConsumerChain.combine(this.onNextCallback, consumer), this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback);
    }

    @Override
    public Single<T> onCancel(Runnable onCancel) {
        return new SingleTappedPublisher<T>(this.source, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, RunnableChain.combine(this.onCancelCallback, onCancel));
    }
}

