/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class DeferredSubscription
extends AtomicReference<Flow.Subscription>
implements Flow.Subscription {
    private static final long serialVersionUID = -6510169867323964352L;
    private final AtomicLong requested = new AtomicLong();

    DeferredSubscription() {
    }

    @Override
    public void request(long n) {
        if (n <= 0L && SubscriptionHelper.badRequest(this)) {
            n = -1L;
            this.requested.set(n);
        }
        SubscriptionHelper.deferredRequest(this, this.requested, n);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    void setSubscription(Flow.Subscription s) {
        SubscriptionHelper.deferredSetOnce(this, this.requested, s);
    }
}

