/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class MultiMapperPublisher<T, R>
implements Multi<R> {
    private final Flow.Publisher<T> source;
    private final Function<? super T, ? extends R> mapper;

    MultiMapperPublisher(Flow.Publisher<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        this.source.subscribe(new MapperSubscriber<T, R>(subscriber, this.mapper));
    }

    static final class MapperSubscriber<T, R>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends R> mapper;
        private Flow.Subscription upstream;

        MapperSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends R> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                R result;
                try {
                    result = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null value.");
                }
                catch (Throwable ex) {
                    s.cancel();
                    this.onError(ex);
                    return;
                }
                this.downstream.onNext(result);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

