/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiSwitchIfEmpty<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Flow.Publisher<T> fallback;

    MultiSwitchIfEmpty(Multi<T> source, Flow.Publisher<T> fallback) {
        this.source = source;
        this.fallback = fallback;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new SwitchIfEmptyMainSubscriber<T>(subscriber, this.fallback));
    }

    static final class SwitchIfEmptyMainSubscriber<T>
    extends AtomicLong
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Flow.Publisher<T> fallback;
        private final FallbackSubscriber<T> fallbackSubscriber;
        private Flow.Subscription upstream;
        private boolean nonEmpty;

        SwitchIfEmptyMainSubscriber(Flow.Subscriber<? super T> downstream, Flow.Publisher<T> fallback) {
            this.downstream = downstream;
            this.fallback = fallback;
            this.fallbackSubscriber = new FallbackSubscriber<T>(downstream, this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            this.nonEmpty = true;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.nonEmpty) {
                this.downstream.onComplete();
            } else {
                this.fallback.subscribe(this.fallbackSubscriber);
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
            if (!this.nonEmpty) {
                SubscriptionHelper.deferredRequest(this.fallbackSubscriber, this, n);
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final Flow.Subscriber<? super T> downstream;
            private final AtomicLong requested;

            FallbackSubscriber(Flow.Subscriber<? super T> downstream, AtomicLong requested) {
                this.downstream = downstream;
                this.requested = requested;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.deferredSetOnce(this, this.requested, subscription);
            }

            @Override
            public void onNext(T item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

