/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.TerminatedFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class MultiTimer
implements Multi<Long> {
    private final long time;
    private final TimeUnit unit;
    private final ScheduledExecutorService executor;

    MultiTimer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        this.time = time;
        this.unit = unit;
        this.executor = executor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Long> subscriber) {
        TimerSubscription subscription = new TimerSubscription(subscriber);
        subscriber.onSubscribe(subscription);
        subscription.setFuture(this.executor.schedule(subscription, this.time, this.unit));
    }

    static final class TimerSubscription
    extends DeferredScalarSubscription<Long>
    implements Callable<Void> {
        private final AtomicReference<Future<?>> future = new AtomicReference();

        TimerSubscription(Flow.Subscriber<? super Long> downstream) {
            super(downstream);
        }

        @Override
        public Void call() {
            this.future.lazySet(TerminatedFuture.FINISHED);
            this.complete(0L);
            return null;
        }

        @Override
        public void cancel() {
            super.cancel();
            TerminatedFuture.cancel(this.future);
        }

        public void setFuture(Future<?> f) {
            TerminatedFuture.setFuture(this.future, f);
        }
    }
}

