/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;

final class MultiReduce<T>
extends CompletionSingle<T> {
    private final Multi<T> source;
    private final BiFunction<T, T, T> reducer;

    MultiReduce(Multi<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new ReducerSubscriber<T>(subscriber, this.reducer));
    }

    static final class ReducerSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final BiFunction<T, T, T> reducer;
        private Flow.Subscription upstream;
        private T current;

        ReducerSubscriber(Flow.Subscriber<? super T> downstream, BiFunction<T, T, T> reducer) {
            super(downstream);
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                T current = this.current;
                if (current == null) {
                    this.current = item;
                } else {
                    try {
                        this.current = Objects.requireNonNull(this.reducer.apply(current, item), "The reducer returned a null item");
                    }
                    catch (Throwable ex) {
                        s.cancel();
                        this.onError(ex);
                    }
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.current = null;
                this.error(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                T current = this.current;
                this.current = null;
                if (current == null) {
                    this.complete();
                } else {
                    this.complete(current);
                }
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

