/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

@FunctionalInterface
public interface RetrySchema {
    public long nextDelay(int var1, long var2);

    public static RetrySchema linear(long firstDelay, long delayIncrement, long maxDelay) {
        return (retryCount, lastDelay) -> {
            long result = firstDelay + delayIncrement * (long)retryCount;
            return result < maxDelay ? result : maxDelay;
        };
    }

    public static RetrySchema constant(long delay) {
        return (retryCount, lastDelay) -> delay;
    }

    public static RetrySchema geometric(long firstDelay, double ratio, long maxDelay) {
        return (retryCount, lastDelay) -> {
            if (retryCount == 0) {
                return firstDelay < maxDelay ? firstDelay : maxDelay;
            }
            long result = Math.round((double)lastDelay * ratio);
            return result < maxDelay ? result : maxDelay;
        };
    }
}

