/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.ConsumerChain;
import io.helidon.common.reactive.MultiTappedPublisher;
import io.helidon.common.reactive.NamedOperator;
import io.helidon.common.reactive.RunnableChain;
import io.helidon.common.reactive.Single;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

final class SingleTappedPublisher<T>
extends CompletionSingle<T>
implements NamedOperator {
    private final Single<T> source;
    private final Consumer<? super Flow.Subscription> onSubscribeCallback;
    private final Consumer<? super T> onNextCallback;
    private final Consumer<? super Throwable> onErrorCallback;
    private final Runnable onCompleteCallback;
    private final LongConsumer onRequestCallback;
    private final Runnable onCancelCallback;
    private String operatorName;

    SingleTappedPublisher(Builder<T> builder) {
        this.source = builder.source;
        this.onSubscribeCallback = builder.onSubscribeCallback;
        this.onNextCallback = builder.onNextCallback;
        this.onErrorCallback = builder.onErrorCallback;
        this.onCompleteCallback = builder.onCompleteCallback;
        this.onRequestCallback = builder.onRequestCallback;
        this.onCancelCallback = builder.onCancelCallback;
        this.operatorName = builder.operatorName;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new MultiTappedPublisher.MultiTappedSubscriber<T>(subscriber, this.onSubscribeCallback, this.onNextCallback, this.onErrorCallback, this.onCompleteCallback, this.onRequestCallback, this.onCancelCallback));
    }

    @Override
    public Single<T> onComplete(Runnable onTerminate) {
        return SingleTappedPublisher.builder(this.source).onSubscribeCallback(this.onSubscribeCallback).onNextCallback(this.onNextCallback).onErrorCallback(this.onErrorCallback).onCompleteCallback(RunnableChain.combine(this.onCompleteCallback, onTerminate)).onRequestCallback(this.onRequestCallback).onCancelCallback(this.onCancelCallback).build();
    }

    @Override
    public Single<T> onError(Consumer<? super Throwable> onErrorConsumer) {
        return SingleTappedPublisher.builder(this.source).onSubscribeCallback(this.onSubscribeCallback).onNextCallback(this.onNextCallback).onErrorCallback(ConsumerChain.combine(this.onErrorCallback, onErrorConsumer)).onCompleteCallback(this.onCompleteCallback).onRequestCallback(this.onRequestCallback).onCancelCallback(this.onCancelCallback).build();
    }

    @Override
    public Single<T> onTerminate(Runnable onTerminate) {
        return SingleTappedPublisher.builder(this.source).onSubscribeCallback(this.onSubscribeCallback).onNextCallback(this.onNextCallback).onErrorCallback(ConsumerChain.combine(this.onErrorCallback, e -> onTerminate.run())).onCompleteCallback(RunnableChain.combine(this.onCompleteCallback, onTerminate)).onRequestCallback(this.onRequestCallback).onCancelCallback(RunnableChain.combine(this.onCancelCallback, onTerminate)).build();
    }

    @Override
    public Single<T> peek(Consumer<? super T> consumer) {
        return SingleTappedPublisher.builder(this.source).onSubscribeCallback(this.onSubscribeCallback).onNextCallback(ConsumerChain.combine(this.onNextCallback, consumer)).onErrorCallback(this.onErrorCallback).onCompleteCallback(this.onCompleteCallback).onRequestCallback(this.onRequestCallback).onCancelCallback(this.onCancelCallback).build();
    }

    @Override
    public Single<T> onCancel(Runnable onCancel) {
        return SingleTappedPublisher.builder(this.source).onSubscribeCallback(this.onSubscribeCallback).onNextCallback(this.onNextCallback).onErrorCallback(this.onErrorCallback).onCompleteCallback(this.onCompleteCallback).onRequestCallback(this.onRequestCallback).onCancelCallback(RunnableChain.combine(this.onCancelCallback, onCancel)).build();
    }

    @Override
    public String operatorName() {
        return this.operatorName;
    }

    public static <T> Builder<T> builder(Single<T> source) {
        return new Builder<T>(source);
    }

    public static class Builder<T>
    implements io.helidon.common.Builder<SingleTappedPublisher<T>> {
        private final Single<T> source;
        private Consumer<? super Flow.Subscription> onSubscribeCallback;
        private Consumer<? super T> onNextCallback;
        private Runnable onCompleteCallback;
        private LongConsumer onRequestCallback;
        private Runnable onCancelCallback;
        private Consumer<? super Throwable> onErrorCallback;
        private String operatorName = MultiTappedPublisher.class.getName();

        private Builder(Single<T> source) {
            this.source = source;
        }

        public SingleTappedPublisher<T> build() {
            return new SingleTappedPublisher(this);
        }

        Builder<T> operatorName(String operatorName) {
            this.operatorName = operatorName;
            return this;
        }

        Builder<T> onSubscribeCallback(Consumer<? super Flow.Subscription> onSubscribeCallback) {
            this.onSubscribeCallback = onSubscribeCallback;
            return this;
        }

        public Builder<T> onSubscribeCallback(Runnable onSubscribeCallback) {
            this.onSubscribeCallback = subscription -> onSubscribeCallback.run();
            return this;
        }

        public Builder<T> onNextCallback(Consumer<? super T> onNextCallback) {
            this.onNextCallback = onNextCallback;
            return this;
        }

        public Builder<T> onCompleteCallback(Runnable onCompleteCallback) {
            this.onCompleteCallback = onCompleteCallback;
            return this;
        }

        public Builder<T> onRequestCallback(LongConsumer onRequestCallback) {
            this.onRequestCallback = onRequestCallback;
            return this;
        }

        public Builder<T> onCancelCallback(Runnable onCancelCallback) {
            this.onCancelCallback = onCancelCallback;
            return this;
        }

        public Builder<T> onErrorCallback(Consumer<? super Throwable> onErrorCallback) {
            this.onErrorCallback = onErrorCallback;
            return this;
        }
    }
}

