/*
 * Copyright (c) 2017, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.config.spi;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Properties;

/**
 * An insertion-ordered properties implementation.
 */
final class OrderedProperties {

    private LinkedHashMap<String, String> map = new LinkedHashMap<>();

    private Properties properties = new Properties() {
        @Override
        public synchronized Object put(Object key, Object value) {
            return map.put(key.toString(), value.toString());
        }
    };

    public void load(Reader reader) throws IOException {
        properties.load(reader);
    }

    LinkedHashMap<String, String> orderedMap() {
        return map;
    }
}
