/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigParser;
import java.util.Objects;
import java.util.Optional;

class InMemoryConfigSource
extends AbstractParsableConfigSource<Object> {
    private final String uri;
    private final ConfigParser.Content<Object> content;

    InMemoryConfigSource(Builder builder) {
        super(builder);
        this.uri = builder.uri();
        this.content = builder.content();
    }

    @Override
    protected String uid() {
        return this.uri;
    }

    @Override
    protected Optional<Object> dataStamp() {
        return Optional.of(this);
    }

    @Override
    protected ConfigParser.Content<Object> content() throws ConfigException {
        return this.content;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder
    extends AbstractParsableConfigSource.Builder<Builder, Void> {
        private String uri;
        private ConfigParser.Content<Object> content;

        Builder() {
            super(Void.class);
        }

        Builder content(String uri, ConfigParser.Content<Object> content) {
            Objects.requireNonNull(uri, "uri cannot be null");
            Objects.requireNonNull(content, "content cannot be null");
            this.uri = uri;
            this.content = content;
            return this;
        }

        @Override
        public InMemoryConfigSource build() {
            Objects.requireNonNull(this.uri, "uri cannot be null");
            Objects.requireNonNull(this.content, "content cannot be null");
            return new InMemoryConfigSource(this);
        }

        private String uri() {
            return this.uri;
        }

        private ConfigParser.Content<Object> content() {
            return this.content;
        }
    }
}

