/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.Builder;
import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.FilesystemWatchPollingStrategy;
import io.helidon.config.internal.ScheduledPollingStrategy;
import io.helidon.config.spi.PollingStrategy;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

public final class PollingStrategies {
    private PollingStrategies() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static PollingStrategy nop() {
        return NopPollingStrategyHolder.NOP;
    }

    public static ScheduledBuilder regular(Duration interval) {
        return new ScheduledBuilder(new ScheduledPollingStrategy.RegularRecurringPolicy(interval));
    }

    public static FilesystemWatchBuilder watch(Path watchedPath) {
        return new FilesystemWatchBuilder(watchedPath);
    }

    private static final class NopPollingStrategyHolder {
        private static final PollingStrategy NOP = () -> Flow.Subscriber::onComplete;

        private NopPollingStrategyHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static final class FilesystemWatchBuilder
    implements Builder<PollingStrategy> {
        private final Path path;
        private ScheduledExecutorService executor = null;
        private WatchEvent.Modifier[] modifiers = null;

        FilesystemWatchBuilder(Path path) {
            this.path = path;
        }

        public FilesystemWatchBuilder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public FilesystemWatchBuilder modifiers(WatchEvent.Modifier ... modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public PollingStrategy build() {
            FilesystemWatchPollingStrategy strategy = new FilesystemWatchPollingStrategy(this.path, this.executor);
            if (this.modifiers != null && this.modifiers.length > 0) {
                strategy.initWatchServiceModifiers(this.modifiers);
            }
            return strategy;
        }

        public PollingStrategy get() {
            return this.build();
        }
    }

    public static final class ScheduledBuilder
    implements Builder<PollingStrategy> {
        private static final String INTERVAL_KEY = "interval";
        private ScheduledPollingStrategy.RecurringPolicy recurringPolicy;
        private ScheduledExecutorService executor;

        ScheduledBuilder(ScheduledPollingStrategy.RecurringPolicy recurringPolicy) {
            this.recurringPolicy = recurringPolicy;
        }

        public static ScheduledBuilder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
            return PollingStrategies.regular(metaConfig.get(INTERVAL_KEY).as(Duration.class).get());
        }

        public ScheduledBuilder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public PollingStrategy build() {
            ScheduledExecutorService executor = this.executor;
            return ScheduledPollingStrategy.create(this.recurringPolicy, executor);
        }

        public PollingStrategy get() {
            return this.build();
        }
    }
}

