/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.SubmissionPublisher;
import io.helidon.config.Config;
import io.helidon.config.ConfigDiff;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.OverrideSources;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.internal.ObjectNodeBuilderImpl;
import io.helidon.config.internal.OverrideConfigFilter;
import io.helidon.config.internal.ValueNodeImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProviderImpl
implements Config.Context {
    private static final Logger LOGGER = Logger.getLogger(ConfigFactory.class.getName());
    private final ConfigMapperManager configMapperManager;
    private final ConfigSource configSource;
    private final OverrideSource overrideSource;
    private final List<Function<Config, ConfigFilter>> filterProviders;
    private final boolean cachingEnabled;
    private final Executor changesExecutor;
    private final SubmissionPublisher<ConfigDiff> changesSubmitter;
    private final Flow.Publisher<ConfigDiff> changesPublisher;
    private final boolean keyResolving;
    private final Function<String, List<String>> aliasGenerator;
    private ConfigSourceChangeEventSubscriber configSourceChangeEventSubscriber;
    private ConfigDiff lastConfigsDiff;
    private Config lastConfig;
    private OverrideSourceChangeEventSubscriber overrideSourceChangeEventSubscriber;
    private volatile boolean overrideChangeComplete;
    private volatile boolean configChangeComplete;

    ProviderImpl(ConfigMapperManager configMapperManager, ConfigSource configSource, OverrideSource overrideSource, List<Function<Config, ConfigFilter>> filterProviders, boolean cachingEnabled, Executor changesExecutor, int changesMaxBuffer, boolean keyResolving, Function<String, List<String>> aliasGenerator) {
        this.configMapperManager = configMapperManager;
        this.configSource = configSource;
        this.overrideSource = overrideSource;
        this.filterProviders = Collections.unmodifiableList(filterProviders);
        this.cachingEnabled = cachingEnabled;
        this.changesExecutor = changesExecutor;
        this.lastConfigsDiff = null;
        this.lastConfig = Config.empty();
        this.keyResolving = keyResolving;
        this.aliasGenerator = aliasGenerator;
        this.changesSubmitter = new RepeatLastEventPublisher<ConfigDiff>(changesExecutor, changesMaxBuffer);
        this.changesPublisher = ConfigHelper.suspendablePublisher(this.changesSubmitter, this::subscribeSources, this::cancelSourcesSubscriptions);
        this.configSourceChangeEventSubscriber = null;
    }

    public Config newConfig() {
        this.lastConfig = this.build(this.configSource.load());
        return this.lastConfig;
    }

    @Override
    public Config reload() {
        this.rebuild(this.configSource.load(), true);
        return this.lastConfig;
    }

    @Override
    public Instant timestamp() {
        return this.lastConfig.timestamp();
    }

    @Override
    public Config last() {
        return this.lastConfig;
    }

    private synchronized Config build(Optional<ConfigNode.ObjectNode> rootNode) {
        rootNode = rootNode.map(this::resolveKeys);
        ChainConfigFilter targetFilter = new ChainConfigFilter();
        if (!this.overrideSource.equals(OverrideSources.empty())) {
            OverrideConfigFilter filter = new OverrideConfigFilter(() -> this.overrideSource.load().orElse(OverrideSource.OverrideData.empty()).data());
            targetFilter.addFilter(filter);
        }
        ConfigFactory factory = new ConfigFactory(this.configMapperManager, rootNode.orElseGet(ConfigNode.ObjectNode::empty), targetFilter, this, this.aliasGenerator);
        Config config = factory.config();
        this.initializeFilters(config, targetFilter);
        if (this.cachingEnabled) {
            targetFilter.enableCaching();
        }
        return config;
    }

    private ConfigNode.ObjectNode resolveKeys(ConfigNode.ObjectNode rootNode) {
        Function<String, String> resolveTokenFunction = Function.identity();
        if (this.keyResolving) {
            Map<String, String> flattenValueNodes = this.flattenNodes(rootNode);
            if (flattenValueNodes.isEmpty()) {
                return rootNode;
            }
            Map<String, String> tokenValueMap = this.tokenToValueMap(flattenValueNodes);
            resolveTokenFunction = token -> {
                if (token.startsWith("$")) {
                    return (String)tokenValueMap.get(ProviderImpl.parseTokenReference(token));
                }
                return token;
            };
        }
        return ObjectNodeBuilderImpl.create(rootNode, resolveTokenFunction).build();
    }

    private Map<String, String> flattenNodes(ConfigNode node) {
        return ConfigFactory.flattenNodes(ConfigKeyImpl.of(), node).filter(e -> e.getValue() instanceof ValueNodeImpl).collect(Collectors.toMap(e -> ((ConfigKeyImpl)e.getKey()).toString(), e -> Config.Key.escapeName(((ValueNodeImpl)e.getValue()).get())));
    }

    private Map<String, String> tokenToValueMap(Map<String, String> flattenValueNodes) {
        return flattenValueNodes.keySet().stream().flatMap(this::tokensFromKey).distinct().collect(Collectors.toMap(Function.identity(), t -> flattenValueNodes.compute(Config.Key.unescapeName(t), (k, v) -> {
            if (v == null) {
                throw new ConfigException(String.format("Missing token '%s' to resolve.", t));
            }
            if (v.equals("")) {
                throw new ConfigException(String.format("Missing value in token '%s' definition.", t));
            }
            if (v.startsWith("$")) {
                throw new ConfigException(String.format("Key token '%s' references to a reference in value. A recursive references is not allowed.", t));
            }
            return v;
        })));
    }

    private Stream<String> tokensFromKey(String s) {
        String[] tokens = s.split("\\.+(?![^(\\$\\{)]*\\})");
        return Arrays.stream(tokens).filter(t -> t.startsWith("$")).map(ProviderImpl::parseTokenReference);
    }

    private static String parseTokenReference(String token) {
        if (token.startsWith("${") && token.endsWith("}")) {
            return token.substring(2, token.length() - 1);
        }
        if (token.startsWith("$")) {
            return token.substring(1);
        }
        return token;
    }

    private synchronized void rebuild(Optional<ConfigNode.ObjectNode> objectNode, boolean force) {
        Config newConfig = this.build(objectNode);
        ConfigDiff configsDiff = ConfigDiff.from(this.lastConfig, newConfig);
        if (!configsDiff.isEmpty()) {
            this.lastConfig = newConfig;
            this.lastConfigsDiff = configsDiff;
            this.fireLastChangeEvent();
        } else {
            if (force) {
                this.lastConfig = newConfig;
            }
            LOGGER.log(Level.FINER, "Change event is not fired, there is no change from the last load.");
        }
    }

    private void fireLastChangeEvent() {
        if (this.lastConfigsDiff != null) {
            LOGGER.log(Level.FINER, String.format("Firing last event %s (again)", this.lastConfigsDiff));
            this.changesSubmitter.offer((Object)this.lastConfigsDiff, (subscriber, event) -> {
                LOGGER.log(Level.FINER, String.format("Event %s has not been delivered to %s.", event, subscriber));
                return false;
            });
        }
    }

    private void subscribeSources() {
        this.subscribeConfigSource();
        this.subscribeOverrideSource();
        this.rebuild(this.configSource.load(), false);
    }

    private void cancelSourcesSubscriptions() {
        this.cancelConfigSource();
        this.cancelOverrideSource();
    }

    private void subscribeConfigSource() {
        this.configSourceChangeEventSubscriber = new ConfigSourceChangeEventSubscriber();
        this.configSource.changes().subscribe((Flow.Subscriber)this.configSourceChangeEventSubscriber);
    }

    private void cancelConfigSource() {
        if (this.configSourceChangeEventSubscriber != null) {
            this.configSourceChangeEventSubscriber.cancelSubscription();
            this.configSourceChangeEventSubscriber = null;
        }
    }

    private void subscribeOverrideSource() {
        this.overrideSourceChangeEventSubscriber = new OverrideSourceChangeEventSubscriber();
        this.overrideSource.changes().subscribe((Flow.Subscriber)this.overrideSourceChangeEventSubscriber);
    }

    private void cancelOverrideSource() {
        if (this.overrideSourceChangeEventSubscriber != null) {
            this.overrideSourceChangeEventSubscriber.cancelSubscription();
            this.overrideSourceChangeEventSubscriber = null;
        }
    }

    private void initializeFilters(Config config, ChainConfigFilter chain) {
        chain.init(config);
        this.filterProviders.stream().map(providerFunction -> (ConfigFilter)providerFunction.apply(config)).sorted(ConfigUtils.priorityComparator(100)).forEachOrdered(chain::addFilter);
        chain.filterProviders.stream().map(providerFunction -> (ConfigFilter)providerFunction.apply(config)).forEachOrdered(filter -> filter.init(config));
    }

    public Flow.Publisher<ConfigDiff> changes() {
        return this.changesPublisher;
    }

    SubmissionPublisher<ConfigDiff> changesSubmitter() {
        return this.changesSubmitter;
    }

    private static class RepeatLastEventSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> delegate;
        private Flow.Subscription subscription;
        private T lastEvent;

        private RepeatLastEventSubscriber(Flow.Subscriber<? super T> delegate) {
            this.delegate = delegate;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.delegate.onSubscribe(subscription);
        }

        public void onNext(T event) {
            if (this.lastEvent == event) {
                this.subscription.request(1L);
            } else {
                this.lastEvent = event;
                this.delegate.onNext(event);
            }
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    private class RepeatLastEventPublisher<T>
    extends SubmissionPublisher<T> {
        private RepeatLastEventPublisher(Executor executor, int maxBufferCapacity) {
            super(executor, maxBufferCapacity);
        }

        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            super.subscribe(new RepeatLastEventSubscriber(subscriber));
            ProviderImpl.this.fireLastChangeEvent();
        }
    }

    private class OverrideSourceChangeEventSubscriber
    implements Flow.Subscriber<Optional<OverrideSource.OverrideData>> {
        private Flow.Subscription subscription;

        private OverrideSourceChangeEventSubscriber() {
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Optional<OverrideSource.OverrideData> overrideData) {
            ProviderImpl.this.changesExecutor.execute(ProviderImpl.this::reload);
        }

        public void onError(Throwable throwable) {
            ProviderImpl.this.changesSubmitter.closeExceptionally((Throwable)new ConfigException(String.format("'%s' override source changes support has failed. %s", ProviderImpl.this.overrideSource.description(), throwable.getLocalizedMessage()), throwable));
        }

        public void onComplete() {
            LOGGER.fine(String.format("'%s' override source changes support has completed.", ProviderImpl.this.overrideSource.description()));
            ProviderImpl.this.overrideChangeComplete = true;
            if (ProviderImpl.this.configChangeComplete) {
                ProviderImpl.this.changesSubmitter.close();
            }
        }

        private void cancelSubscription() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }
    }

    private class ConfigSourceChangeEventSubscriber
    implements Flow.Subscriber<Optional<ConfigNode.ObjectNode>> {
        private Flow.Subscription subscription;

        private ConfigSourceChangeEventSubscriber() {
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Optional<ConfigNode.ObjectNode> objectNode) {
            ProviderImpl.this.changesExecutor.execute(() -> ProviderImpl.this.rebuild(objectNode, false));
        }

        public void onError(Throwable throwable) {
            ProviderImpl.this.changesSubmitter.closeExceptionally((Throwable)new ConfigException(String.format("'%s' config source changes support has failed. %s", ProviderImpl.this.configSource.description(), throwable.getLocalizedMessage()), throwable));
        }

        public void onComplete() {
            LOGGER.fine(String.format("'%s' config source changes support has completed.", ProviderImpl.this.configSource.description()));
            ProviderImpl.this.configChangeComplete = true;
            if (ProviderImpl.this.overrideChangeComplete) {
                ProviderImpl.this.changesSubmitter.close();
            }
        }

        private void cancelSubscription() {
            this.subscription.cancel();
        }
    }

    static class ChainConfigFilter
    implements ConfigFilter {
        private final List<Function<Config, ConfigFilter>> filterProviders = new ArrayList<Function<Config, ConfigFilter>>();
        private boolean cachingEnabled = false;
        private ConcurrentMap<Config.Key, String> valueCache;
        private Config config;

        ChainConfigFilter() {
        }

        @Override
        public void init(Config config) {
            this.config = config;
        }

        void addFilter(ConfigFilter filter) {
            if (this.cachingEnabled) {
                throw new IllegalStateException("Cannot add new filter to the chain when cache is already enabled.");
            }
            this.filterProviders.add(config -> filter);
        }

        void addFilter(Function<Config, ConfigFilter> filterProvider) {
            if (this.cachingEnabled) {
                throw new IllegalStateException("Cannot add new filter provider to the chain when cache is already enabled.");
            }
            this.filterProviders.add(filterProvider);
        }

        @Override
        public String apply(Config.Key key, String stringValue) {
            if (this.cachingEnabled) {
                if (!this.valueCache.containsKey(key)) {
                    String value = this.proceedFilters(key, stringValue);
                    this.valueCache.put(key, value);
                    return value;
                }
                return (String)this.valueCache.get(key);
            }
            return this.proceedFilters(key, stringValue);
        }

        private String proceedFilters(Config.Key key, String stringValue) {
            for (Function<Config, ConfigFilter> configFilterProvider : this.filterProviders) {
                stringValue = configFilterProvider.apply(this.config).apply(key, stringValue);
            }
            return stringValue;
        }

        void enableCaching() {
            this.cachingEnabled = true;
            this.valueCache = new ConcurrentHashMap<Config.Key, String>();
        }
    }
}

