/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.internal.FileSourceHelper;
import io.helidon.config.spi.AbstractOverrideSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileOverrideSource
extends AbstractOverrideSource<byte[]> {
    private static final Logger LOGGER = Logger.getLogger(FileOverrideSource.class.getName());
    private final Path filePath;

    FileOverrideSource(FileBuilder builder, Path filePath) {
        super(builder);
        this.filePath = filePath;
    }

    @Override
    protected String uid() {
        return this.filePath.toString();
    }

    @Override
    protected Optional<byte[]> dataStamp() {
        return Optional.ofNullable(FileSourceHelper.digest(this.filePath));
    }

    @Override
    protected AbstractSource.Data<OverrideSource.OverrideData, byte[]> loadData() throws ConfigException {
        Optional<byte[]> digest = this.dataStamp();
        LOGGER.log(Level.FINE, String.format("Getting content from '%s'.", this.filePath));
        try {
            OverrideSource.OverrideData overrideData = OverrideSource.OverrideData.create(new StringReader(FileSourceHelper.safeReadContent(this.filePath)));
            return new AbstractSource.Data<OverrideSource.OverrideData, byte[]>(Optional.of(overrideData), digest);
        }
        catch (IOException e) {
            throw new ConfigException("Cannot load data from source.", e);
        }
    }

    public static final class FileBuilder
    extends AbstractOverrideSource.Builder<FileBuilder, Path> {
        private Path path;

        public FileBuilder(Path path) {
            super(Path.class);
            Objects.requireNonNull(path, "file path cannot be null");
            this.path = path;
        }

        @Override
        protected Path target() {
            return this.path;
        }

        @Override
        public OverrideSource build() {
            return new FileOverrideSource(this, this.path);
        }

        PollingStrategy pollingStrategyInternal() {
            return super.pollingStrategy();
        }
    }
}

