/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MapConfigSource
implements ConfigSource {
    private final Map<String, String> map;
    private final String mapSourceName;
    private final boolean strict;

    public MapConfigSource(Map<String, String> map, boolean strict, String mapSourceName) {
        Objects.requireNonNull(map, "map cannot be null");
        Objects.requireNonNull(mapSourceName, "mapSourceName cannot be null");
        this.map = map;
        this.strict = strict;
        this.mapSourceName = mapSourceName;
    }

    @Override
    public String description() {
        return ConfigSource.super.description() + (this.mapSourceName.isEmpty() ? "" : "[" + this.mapSourceName + "]");
    }

    @Override
    public Optional<ConfigNode.ObjectNode> load() {
        return Optional.of(ConfigUtils.mapToObjectNode(this.map, this.strict));
    }
}

