/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.ConfigHelper;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Priority;

@Priority(value=200)
public class PropertiesConfigParser
implements ConfigParser {
    public static final String MEDIA_TYPE_TEXT_JAVA_PROPERTIES = "text/x-java-properties";
    public static final int PRIORITY = 200;
    private static final Set<String> SUPPORTED_MEDIA_TYPES = CollectionsHelper.setOf((Object[])new String[]{"text/x-java-properties"});

    @Override
    public Set<String> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public <S> ConfigNode.ObjectNode parse(ConfigParser.Content<S> content) throws ConfigParserException {
        Properties properties = new Properties();
        try (AutoCloseable readable = (AutoCloseable)content.asReadable();){
            properties.load(ConfigHelper.createReader((Readable)((Object)readable)));
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), e);
        }
        return ConfigUtils.mapToObjectNode(ConfigUtils.propertiesToMap(properties), true);
    }
}

