/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.AbstractOverrideSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlOverrideSource
extends AbstractOverrideSource<Instant> {
    private static final Logger LOGGER = Logger.getLogger(UrlOverrideSource.class.getName());
    private static final String GET_METHOD = "GET";
    private static final String HEAD_METHOD = "HEAD";
    private final URL url;

    UrlOverrideSource(UrlBuilder builder, URL url) {
        super(builder);
        this.url = url;
    }

    @Override
    protected AbstractSource.Data<OverrideSource.OverrideData, Instant> loadData() throws ConfigException {
        try {
            Instant timestamp;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod(GET_METHOD);
            if (connection.getLastModified() != 0L) {
                timestamp = Instant.ofEpochMilli(connection.getLastModified());
            } else {
                timestamp = Instant.now();
                LOGGER.fine("Missing GET '" + this.url + "' response header 'Last-Modified'. Used current time '" + timestamp + "' as a content timestamp.");
            }
            InputStreamReader reader = new InputStreamReader(connection.getInputStream(), ConfigUtils.getContentCharset(connection.getContentEncoding()));
            return new AbstractSource.Data<OverrideSource.OverrideData, Instant>(Optional.of(OverrideSource.OverrideData.create(reader)), Optional.of(timestamp));
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at url '" + this.url + "' GET is not accessible.", ex);
        }
    }

    @Override
    protected String uid() {
        return this.url.toString();
    }

    @Override
    protected Optional<Instant> dataStamp() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod(HEAD_METHOD);
            if (connection.getLastModified() != 0L) {
                return Optional.of(Instant.ofEpochMilli(connection.getLastModified()));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, ex, () -> "Configuration at url '" + this.url + "' HEAD is not accessible.");
        }
        Optional<Instant> timestamp = Optional.of(Instant.MAX);
        LOGGER.finer("Missing HEAD '" + this.url + "' response header 'Last-Modified'. Used time '" + timestamp + "' as a content timestamp.");
        return timestamp;
    }

    public static final class UrlBuilder
    extends AbstractOverrideSource.Builder<UrlBuilder, URL> {
        private URL url;

        public UrlBuilder(URL url) {
            super(URL.class);
            Objects.requireNonNull(url, "url cannot be null");
            this.url = url;
        }

        @Override
        protected URL target() {
            return this.url;
        }

        @Override
        public OverrideSource build() {
            return new UrlOverrideSource(this, this.url);
        }

        PollingStrategy pollingStrategyInternal() {
            return super.pollingStrategy();
        }
    }
}

