/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.spi.AbstractConfigSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.util.Optional;

public abstract class AbstractParsableConfigSource<S>
extends AbstractConfigSource<S> {
    private final String mediaType;
    private final ConfigParser parser;

    protected AbstractParsableConfigSource(Builder builder) {
        super(builder);
        this.mediaType = builder.mediaType();
        this.parser = builder.parser();
    }

    @Override
    protected AbstractSource.Data<ConfigNode.ObjectNode, S> loadData() {
        ConfigParser.Content<S> content = this.content();
        ConfigNode.ObjectNode objectNode = this.parse(this.configContext(), content);
        return new AbstractSource.Data<ConfigNode.ObjectNode, S>(Optional.of(objectNode), content.stamp());
    }

    protected String mediaType() {
        return this.mediaType;
    }

    protected ConfigParser parser() {
        return this.parser;
    }

    protected abstract ConfigParser.Content<S> content() throws ConfigException;

    private ConfigNode.ObjectNode parse(ConfigContext context, ConfigParser.Content<S> content) throws ConfigParserException {
        return OptionalHelper.from(Optional.ofNullable(this.parser())).or(() -> context.findParser(Optional.ofNullable(content.mediaType()).orElseThrow(() -> new ConfigException("Unknown media type.")))).asOptional().map(parser -> parser.parse(content)).orElseThrow(() -> new ConfigException("Cannot find suitable parser for '" + content.mediaType() + "' media type."));
    }

    public static abstract class Builder<B extends Builder<B, T>, T>
    extends AbstractConfigSource.Builder<B, T> {
        private static final String MEDIA_TYPE_KEY = "media-type";
        private String mediaType;
        private ConfigParser parser;

        protected Builder(Class<T> targetType) {
            super(targetType);
        }

        @Override
        protected B init(Config metaConfig) {
            metaConfig.get(MEDIA_TYPE_KEY).asString().ifPresent(this::mediaType);
            return (B)((Builder)super.init(metaConfig));
        }

        public B mediaType(String mediaType) {
            this.mediaType = mediaType;
            return (B)((Builder)this.thisBuilder());
        }

        public B parser(ConfigParser parser) {
            this.parser = parser;
            return (B)((Builder)this.thisBuilder());
        }

        protected String mediaType() {
            return this.mediaType;
        }

        protected ConfigParser parser() {
            return this.parser;
        }
    }
}

