/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.SubmissionPublisher;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.PollingStrategies;
import io.helidon.config.RetryPolicies;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.spi.ConfigParserException;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.PollingStrategyConfigMapper;
import io.helidon.config.spi.RetryPolicy;
import io.helidon.config.spi.Source;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSource<T, S>
implements Source<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractSource.class.getName());
    private final boolean mandatory;
    private final PollingStrategy pollingStrategy;
    private final Executor changesExecutor;
    private final RetryPolicy retryPolicy;
    private final SubmissionPublisher<Optional<T>> changesSubmitter;
    private final Flow.Publisher<Optional<T>> changesPublisher;
    private Optional<Data<T, S>> lastData;
    private PollingEventSubscriber pollingEventSubscriber;

    AbstractSource(Builder<?, ?, ?> builder) {
        this.mandatory = builder.isMandatory();
        this.pollingStrategy = builder.pollingStrategy();
        this.changesExecutor = builder.changesExecutor();
        this.retryPolicy = builder.retryPolicy();
        this.changesSubmitter = new SubmissionPublisher(this.changesExecutor, builder.changesMaxBuffer());
        this.changesPublisher = ConfigHelper.suspendablePublisher(this.changesSubmitter, this::subscribePollingStrategy, this::cancelPollingStrategy);
        this.lastData = Optional.empty();
    }

    void reload() {
        LOGGER.log(Level.FINEST, "reload");
        boolean hasChanged = false;
        Optional<Data<Data<T, S>, S>> newData = this.loadDataChangedSinceLastLoad();
        if (newData.isPresent()) {
            Optional<T> newObjectNode = newData.get().data();
            if (this.lastData.isPresent()) {
                Optional<T> lastObjectNode = this.lastData.get().data();
                hasChanged = this.hasChanged(lastObjectNode, newObjectNode);
            } else {
                hasChanged = true;
            }
            this.lastData = newData;
        }
        if (hasChanged) {
            this.fireChangeEvent();
        } else {
            LOGGER.log(Level.FINE, String.format("Source data %s has not changed.", this.description()));
        }
    }

    SubmissionPublisher<Optional<T>> changesSubmitter() {
        return this.changesSubmitter;
    }

    void subscribePollingStrategy() {
        this.pollingEventSubscriber = new PollingEventSubscriber();
        this.pollingStrategy.ticks().subscribe((Flow.Subscriber)this.pollingEventSubscriber);
    }

    protected String uid() {
        return "";
    }

    void cancelPollingStrategy() {
        this.pollingEventSubscriber.cancelSubscription();
        this.pollingEventSubscriber = null;
    }

    Flow.Publisher<Optional<T>> changesPublisher() {
        return this.changesPublisher;
    }

    PollingStrategy pollingStrategy() {
        return this.pollingStrategy;
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    protected void fireChangeEvent() {
        this.changesSubmitter.offer(this.lastData.flatMap(Data::data), (subscriber, event) -> {
            LOGGER.log(Level.FINER, String.format("Event %s has not been delivered to %s.", event, subscriber));
            return false;
        });
    }

    protected Data<T, S> processLoadedData(Data<T, S> data) {
        return data;
    }

    protected abstract Optional<S> dataStamp();

    Optional<Data<T, S>> lastData() {
        return this.lastData;
    }

    @Override
    public final Optional<T> load() {
        Optional<Data<Data<T, S>, S>> loadedData = this.loadDataChangedSinceLastLoad();
        if (loadedData.isPresent()) {
            this.lastData = loadedData;
        }
        if (this.lastData.isPresent()) {
            return this.lastData.get().data();
        }
        return Optional.empty();
    }

    Optional<Data<T, S>> loadDataChangedSinceLastLoad() {
        block4: {
            Optional lastDatastamp = this.lastData.flatMap(Data::stamp);
            Optional<S> dataStamp = this.dataStamp();
            if (!this.lastData.isPresent() || !dataStamp.equals(this.lastData.get().stamp())) {
                LOGGER.log(Level.FINE, String.format("Source %s has changed to %s from %s.", this.description(), dataStamp, lastDatastamp));
                try {
                    Data data = this.retryPolicy.execute(this::loadData);
                    if (!data.stamp().equals(lastDatastamp)) {
                        LOGGER.log(Level.FINE, String.format("Source %s has changed to %s from %s.", this.description(), dataStamp, lastDatastamp));
                        return Optional.of(this.processLoadedData(data));
                    }
                    LOGGER.log(Level.FINE, String.format("Config data %s has not changed, last stamp was %s.", this.description(), lastDatastamp));
                }
                catch (ConfigException ex) {
                    this.processMissingData(ex);
                    if (!this.lastData.isPresent() || !this.lastData.get().data().isPresent()) break block4;
                    LOGGER.log(Level.FINE, String.format("Config data %s has has been removed.", this.description()));
                    return Optional.of(new Data(Optional.empty(), Optional.empty()));
                }
            }
        }
        return Optional.empty();
    }

    protected abstract Data<T, S> loadData() throws ConfigException;

    private void processMissingData(ConfigException cause) {
        if (this.isMandatory()) {
            String message = String.format("Cannot load data from mandatory source %s.", this.description());
            if (cause == null) {
                throw new ConfigException(message);
            }
            throw new ConfigException(message + " " + cause.getLocalizedMessage(), cause);
        }
        String message = String.format("Cannot load data from optional source %s. Will not be used to load from.", this.description());
        if (cause == null) {
            LOGGER.log(Level.CONFIG, message);
        } else {
            if (cause instanceof ConfigParserException) {
                LOGGER.log(Level.WARNING, message + " " + cause.getLocalizedMessage());
            } else {
                LOGGER.log(Level.CONFIG, message + " " + cause.getLocalizedMessage());
            }
            LOGGER.log(Level.FINE, String.format("Load of '%s' source failed with an exception.", this.description()), cause);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasChanged(Optional<T> lastObject, Optional<T> newObject) {
        if (lastObject.isPresent()) {
            if (!newObject.isPresent()) return true;
            if (lastObject.get().equals(newObject.get())) return false;
            return true;
        }
        if (!newObject.isPresent()) return false;
        return true;
    }

    @Override
    public final String description() {
        return this.formatDescription(this.uid());
    }

    String formatDescription(String uid) {
        return Source.super.description() + "[" + uid + "]" + (this.isMandatory() ? "" : "?") + (this.pollingStrategy().equals(PollingStrategies.nop()) ? "" : "*");
    }

    private class PollingEventSubscriber
    implements Flow.Subscriber<PollingStrategy.PollingEvent> {
        private Flow.Subscription subscription;
        private volatile boolean reloadLogged = false;

        private PollingEventSubscriber() {
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        public void onNext(PollingStrategy.PollingEvent item) {
            AbstractSource.this.changesExecutor.execute(this::safeReload);
        }

        private void safeReload() {
            try {
                AbstractSource.this.reload();
                if (this.reloadLogged) {
                    String message = String.format("Reload of override source [%s] succeeded again. Polling will continue.", AbstractSource.this.description());
                    LOGGER.log(AbstractSource.this.isMandatory() ? Level.WARNING : Level.CONFIG, message);
                    this.reloadLogged = false;
                }
            }
            catch (Exception ex) {
                if (!this.reloadLogged) {
                    String message = String.format("Reload of override source [%s] failed. Polling will continue. %s", AbstractSource.this.description(), ex.getLocalizedMessage());
                    LOGGER.log(AbstractSource.this.isMandatory() ? Level.WARNING : Level.CONFIG, message);
                    LOGGER.log(Level.CONFIG, String.format("Reload of '%s' override source failed with an exception.", AbstractSource.this.description()), ex);
                    this.reloadLogged = true;
                }
            }
            finally {
                this.subscription.request(1L);
            }
        }

        public void onError(Throwable throwable) {
            AbstractSource.this.changesSubmitter.closeExceptionally((Throwable)new ConfigException(String.format("Polling strategy '%s' has failed. Polling of '%s' source will not continue. %s", AbstractSource.this.pollingStrategy, AbstractSource.this.description(), throwable.getLocalizedMessage()), throwable));
        }

        public void onComplete() {
            LOGGER.fine(String.format("Polling strategy '%s' has completed. Polling of '%s' source will not continue.", AbstractSource.this.pollingStrategy, AbstractSource.this.description()));
            AbstractSource.this.changesSubmitter.close();
        }

        private void cancelSubscription() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }
    }

    public static final class Data<D, S> {
        private final Optional<D> data;
        private final Optional<S> stamp;

        public Data() {
            this.stamp = Optional.empty();
            this.data = Optional.empty();
        }

        public Data(Optional<D> data, Optional<S> stamp) {
            Objects.requireNonNull(data);
            Objects.requireNonNull(stamp);
            this.stamp = stamp;
            this.data = data;
        }

        public Optional<D> data() {
            return this.data;
        }

        public Optional<S> stamp() {
            return this.stamp;
        }
    }

    public static abstract class Builder<B extends Builder<B, T, S>, T, S> {
        static final Executor DEFAULT_CHANGES_EXECUTOR = Executors.newCachedThreadPool(new ConfigThreadFactory("source"));
        private static final String OPTIONAL_KEY = "optional";
        private static final String POLLING_STRATEGY_KEY = "polling-strategy";
        private static final String RETRY_POLICY_KEY = "retry-policy";
        private final B thisBuilder;
        private final Class<T> targetType;
        private boolean mandatory;
        private Supplier<PollingStrategy> pollingStrategySupplier;
        private Executor changesExecutor;
        private int changesMaxBuffer;
        private Supplier<RetryPolicy> retryPolicySupplier;

        protected Builder(Class<T> targetType) {
            this.targetType = targetType;
            this.thisBuilder = this;
            this.mandatory = true;
            this.pollingStrategySupplier = PollingStrategies::nop;
            this.changesExecutor = DEFAULT_CHANGES_EXECUTOR;
            this.changesMaxBuffer = Flow.defaultBufferSize();
            this.retryPolicySupplier = RetryPolicies::justCall;
        }

        protected B thisBuilder() {
            return this.thisBuilder;
        }

        protected B init(Config metaConfig) {
            metaConfig.get(OPTIONAL_KEY).asBoolean().filter(value -> value).ifPresent(value -> this.optional());
            metaConfig.get(POLLING_STRATEGY_KEY).ifExists(cfg -> this.pollingStrategy(PollingStrategyConfigMapper.instance().apply((Config)cfg, this.targetType)));
            metaConfig.get(RETRY_POLICY_KEY).as(RetryPolicy::create).ifPresent(this::retryPolicy);
            return this.thisBuilder;
        }

        public B pollingStrategy(Supplier<PollingStrategy> pollingStrategySupplier) {
            Objects.requireNonNull(pollingStrategySupplier, "pollingStrategy cannot be null");
            this.pollingStrategySupplier = pollingStrategySupplier;
            return this.thisBuilder;
        }

        public final B pollingStrategy(Function<T, Supplier<PollingStrategy>> pollingStrategyProvider) {
            this.pollingStrategy(() -> (PollingStrategy)((Supplier)pollingStrategyProvider.apply(this.target())).get());
            return this.thisBuilder;
        }

        protected T target() {
            return null;
        }

        public B optional() {
            this.mandatory = false;
            return this.thisBuilder;
        }

        public B changesExecutor(Executor changesExecutor) {
            Objects.requireNonNull(changesExecutor, "changesExecutor cannot be null");
            this.changesExecutor = changesExecutor;
            return this.thisBuilder;
        }

        public B changesMaxBuffer(int changesMaxBuffer) {
            this.changesMaxBuffer = changesMaxBuffer;
            return this.thisBuilder;
        }

        public B retryPolicy(Supplier<RetryPolicy> retryPolicySupplier) {
            this.retryPolicySupplier = retryPolicySupplier;
            return this.thisBuilder;
        }

        public abstract S build();

        protected boolean isMandatory() {
            return this.mandatory;
        }

        protected PollingStrategy pollingStrategy() {
            PollingStrategy pollingStrategy = this.pollingStrategySupplier.get();
            Objects.requireNonNull(pollingStrategy, "pollingStrategy cannot be null");
            return pollingStrategy;
        }

        protected Executor changesExecutor() {
            return this.changesExecutor;
        }

        protected int changesMaxBuffer() {
            return this.changesMaxBuffer;
        }

        protected RetryPolicy retryPolicy() {
            return this.retryPolicySupplier.get();
        }
    }
}

