/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health;

import io.helidon.health.HealthCheckResponseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

public class HealthCheckResponseProviderImpl
implements HealthCheckResponseProvider {
    public HealthCheckResponseBuilder createResponseBuilder() {
        return new HealthCheckResponseBuilder(){
            private final Map<String, Object> data = new HashMap<String, Object>();
            private String name;
            private HealthCheckResponse.State state = HealthCheckResponse.State.UP;

            public HealthCheckResponseBuilder name(String name) {
                Objects.requireNonNull(name, "Name cannot be null");
                this.name = name;
                return this;
            }

            public HealthCheckResponseBuilder withData(String key, String value) {
                Objects.requireNonNull(key, "key cannot be null");
                this.data.put(key, value);
                return this;
            }

            public HealthCheckResponseBuilder withData(String key, long value) {
                Objects.requireNonNull(key, "key cannot be null");
                this.data.put(key, value);
                return this;
            }

            public HealthCheckResponseBuilder withData(String key, boolean value) {
                Objects.requireNonNull(key, "key cannot be null");
                this.data.put(key, value);
                return this;
            }

            public HealthCheckResponseBuilder up() {
                this.state = HealthCheckResponse.State.UP;
                return this;
            }

            public HealthCheckResponseBuilder down() {
                this.state = HealthCheckResponse.State.DOWN;
                return this;
            }

            public HealthCheckResponseBuilder state(boolean up) {
                if (up) {
                    this.up();
                } else {
                    this.down();
                }
                return this;
            }

            public HealthCheckResponse build() {
                return new HealthCheckResponseImpl(this.name, this.state, this.data);
            }
        };
    }
}

