/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health;

import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.media.jsonp.server.JsonSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public final class HealthSupport
implements Service {
    public static final String DEFAULT_WEB_CONTEXT = "/health";
    private static final Logger LOGGER = Logger.getLogger(HealthSupport.class.getName());
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final String webContext;
    private final List<HealthCheck> allChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> livenessChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new LinkedList<HealthCheck>();
    private final boolean includeAll;
    private final Set<String> includedHealthChecks;
    private final Set<String> excludedHealthChecks;

    private HealthSupport(Builder builder) {
        this.webContext = builder.webContext;
        builder.allChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.allChecks::add);
        builder.readinessChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.readinessChecks::add);
        builder.livenessChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.livenessChecks::add);
        this.includedHealthChecks = new HashSet<String>(builder.includedHealthChecks);
        this.excludedHealthChecks = new HashSet<String>(builder.excludedHealthChecks);
        this.includeAll = this.includedHealthChecks.isEmpty();
    }

    public void update(Routing.Rules rules) {
        rules.get(this.webContext + "[/{*}]", new Handler[]{JsonSupport.create()}).get(this.webContext, new Handler[]{this::callAll}).get(this.webContext + "/live", new Handler[]{this::callLiveness}).get(this.webContext + "/ready", new Handler[]{this::callReadiness});
    }

    private void callAll(ServerRequest req, ServerResponse res) {
        HealthResponse hres = this.callHealthChecks(this.allChecks);
        res.status(hres.status());
        res.send((Object)hres.json);
    }

    private void callLiveness(ServerRequest req, ServerResponse res) {
        HealthResponse hres = this.callHealthChecks(this.livenessChecks);
        res.status(hres.status());
        res.send((Object)hres.json);
    }

    private void callReadiness(ServerRequest req, ServerResponse res) {
        HealthResponse hres = this.callHealthChecks(this.readinessChecks);
        res.status(hres.status());
        res.send((Object)hres.json);
    }

    HealthResponse callHealthChecks(List<HealthCheck> healthChecks) {
        List<HcResponse> responses = healthChecks.stream().map(this::callHealthChecks).filter(this::notExcluded).filter(this::allOrIncluded).sorted(Comparator.comparing(HcResponse::name)).collect(Collectors.toList());
        HealthCheckResponse.State state = responses.stream().map(HcResponse::state).filter(arg_0 -> HealthCheckResponse.State.DOWN.equals(arg_0)).findFirst().orElse(HealthCheckResponse.State.UP);
        Http.ResponseStatus status = (Http.ResponseStatus)responses.stream().filter(HcResponse::internalError).findFirst().map(it -> Http.Status.INTERNAL_SERVER_ERROR_500).orElse(state == HealthCheckResponse.State.UP ? Http.Status.OK_200 : Http.Status.SERVICE_UNAVAILABLE_503);
        JsonObject json = this.toJson(state, responses);
        return new HealthResponse(status, json);
    }

    private JsonObject toJson(HealthCheckResponse.State state, List<HcResponse> responses) {
        JsonObjectBuilder jsonBuilder = JSON.createObjectBuilder().add("outcome", state.toString()).add("status", state.toString());
        JsonArrayBuilder checkArrayBuilder = JSON.createArrayBuilder();
        for (HcResponse r : responses) {
            JsonObjectBuilder checkBuilder = JSON.createObjectBuilder();
            checkBuilder.add("name", r.name());
            checkBuilder.add("state", r.state().toString());
            checkBuilder.add("status", r.state().toString());
            Optional<Map<String, Object>> data = r.data();
            data.ifPresent(m -> checkBuilder.add("data", JSON.createObjectBuilder(m)));
            checkArrayBuilder.add(checkBuilder);
        }
        jsonBuilder.add("checks", checkArrayBuilder);
        return jsonBuilder.build();
    }

    private boolean allOrIncluded(HcResponse response) {
        return this.includeAll || this.includedHealthChecks.contains(response.hcr.getName());
    }

    private boolean notExcluded(HcResponse response) {
        return !this.excludedHealthChecks.contains(response.hcr.getName());
    }

    private HcResponse callHealthChecks(HealthCheck hc) {
        try {
            return new HcResponse(hc.call());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compute health check for " + hc.getClass().getName(), e);
            return new HcResponse(HealthCheckResponse.named((String)hc.getClass().getName()).withData("message", "Failed to compute health. Error logged").down().build(), true);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HealthSupport create() {
        return HealthSupport.builder().build();
    }

    public static HealthSupport create(Config config) {
        return HealthSupport.builder().config(config).build();
    }

    static final class HealthResponse {
        private Http.ResponseStatus status;
        private JsonObject json;

        private HealthResponse(Http.ResponseStatus status, JsonObject json) {
            this.status = status;
            this.json = json;
        }

        Http.ResponseStatus status() {
            return this.status;
        }

        JsonObject json() {
            return this.json;
        }
    }

    private static final class HcResponse {
        private final HealthCheckResponse hcr;
        private final boolean internalServerError;

        private HcResponse(HealthCheckResponse response, boolean internalServerError) {
            this.hcr = response;
            this.internalServerError = internalServerError;
        }

        private HcResponse(HealthCheckResponse response) {
            this(response, false);
        }

        String name() {
            return this.hcr.getName();
        }

        HealthCheckResponse.State state() {
            return this.hcr.getState();
        }

        boolean internalError() {
            return this.internalServerError;
        }

        public Optional<Map<String, Object>> data() {
            return this.hcr.getData();
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<HealthSupport> {
        private final Set<HealthCheck> allChecks = new LinkedHashSet<HealthCheck>();
        private final Set<HealthCheck> livenessChecks = new LinkedHashSet<HealthCheck>();
        private final Set<HealthCheck> readinessChecks = new LinkedHashSet<HealthCheck>();
        private final Set<Class<?>> excludedClasses = new HashSet();
        private final Set<String> includedHealthChecks = new HashSet<String>();
        private final Set<String> excludedHealthChecks = new HashSet<String>();
        private String webContext = "/health";

        private Builder() {
        }

        public HealthSupport build() {
            return new HealthSupport(this);
        }

        public Builder webContext(String path) {
            this.webContext = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        @Deprecated
        public Builder add(HealthCheck ... healthChecks) {
            this.allChecks.addAll(Arrays.asList(healthChecks));
            return this;
        }

        @Deprecated
        public Builder add(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            return this;
        }

        public Builder addIncluded(String healthCheckName) {
            this.includedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addIncluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.includedHealthChecks.addAll(names);
            return this;
        }

        public Builder addExcluded(String healthCheckName) {
            this.excludedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addExcluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.excludedHealthChecks.addAll(names);
            return this;
        }

        public Builder config(Config config) {
            config.get("web-context").asString().ifPresent(this::webContext);
            config.get("include").asList(String.class).ifPresent(list -> list.forEach(this::addIncluded));
            config.get("exclude").asList(String.class).ifPresent(list -> list.forEach(this::addExcluded));
            config.get("exclude-classes").asList(Class.class).ifPresent(list -> list.forEach(this::addExcludedClass));
            return this;
        }

        public Builder addExcludedClass(Class<?> aClass) {
            this.excludedClasses.add(aClass);
            return this;
        }

        public Builder addLiveness(HealthCheck ... healthCheck) {
            for (HealthCheck check : healthCheck) {
                this.allChecks.add(check);
                this.livenessChecks.add(check);
            }
            return this;
        }

        public Builder addReadiness(HealthCheck ... healthCheck) {
            for (HealthCheck check : healthCheck) {
                this.allChecks.add(check);
                this.readinessChecks.add(check);
            }
            return this;
        }
    }
}

